/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.bonus;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.bonus.SignRecord;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecordQueryTime;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BonusQueryCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(BonusQueryCmd.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    @CmdMapper(value={"/bonus/querybonusinfo.do"})
    public Object queryBonusInfo(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.getMainParamSafe(request, response, false);
        HashMap<String, Object> result = new HashMap<String, Object>();
        String userId = "";
        try {
            userId = mainParam.getUserid() + "";
            this.addBonusInfo(result, userId);
            this.addSignDays(result, userId);
            this.getPrizeNum(result, userId);
            result.put("code", "00");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            result.put("code", "99");
            result.put("msg", "\u67e5\u8be2\u5931\u8d25");
            logger.error("\u7528\u6237[" + userId + "]\u67e5\u8be2\u7528\u6237\u79ef\u5206\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
    }

    @CmdMapper(value={"/bonus/queryTodayBonus.do"})
    public Object queryTodayBonus(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.getMainParamSafe(request, response, false);
        HashMap<String, Object> result = new HashMap<String, Object>();
        String userId = "";
        try {
            userId = mainParam.getUserid() + "";
            Integer todayBonus = BonusClient.queryTodayBonus(userId);
            result.put("todayBonus", todayBonus);
            result.put("code", "00");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            result.put("code", "99");
            result.put("msg", "\u67e5\u8be2\u5931\u8d25");
            logger.error("\u7528\u6237[" + userId + "]\u67e5\u8be2\u7528\u6237\u5f53\u5929\u83b7\u5f97\u7684\u79ef\u5206\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
    }

    private void addBonusInfo(Map<String, Object> result, String userId) {
        BonusClient.UserBonus userBonus = BonusClient.queryBonus(userId);
        result.put("useId", userBonus.getUserId());
        result.put("userName", userBonus.getUserName());
        result.put("bonusNum", userBonus.getBonusNum());
        result.put("rechargeSum", userBonus.getRechargeSum());
        result.put("consumeSum", userBonus.getConsumeSum());
        result.put("bonusLevel", userBonus.getBonusLevel());
        result.put("nextLevelNeedNum", userBonus.getNextLevelNeedNum());
        result.put("bonusRanking", userBonus.getBonusRanking());
        result.put("levelName", userBonus.getLevelName());
        result.put("levelUrl", userBonus.getLevelUrl());
    }

    private void addSignDays(Map<String, Object> result, String userId) {
        try {
            SignRecord signRecord = FacadeFactory.INSTANCE.getSignRecordBo().findLatestSign(userId);
            if (signRecord == null) {
                result.put("seriesSignDays", 0);
                result.put("sumSignDays", 0);
                return;
            }
            result.put("sumSignDays", signRecord.getSignSumDays());
            result.put("totalSignBonusNum", signRecord.getSignTotalBonusNum());
            result.put("isSign", false);
            if (this.isTodayOrderSign(signRecord)) {
                result.put("isSign", true);
            }
            if (this.isTodayOrderYesSign(signRecord)) {
                result.put("seriesSignDays", signRecord.getSeriesSignDays());
                result.put("todaySignIndex", signRecord.getTodaySignIndex());
                result.put("todaySignBonusNum", signRecord.getBonusNum());
            } else {
                result.put("seriesSignDays", 0);
                result.put("todaySignIndex", 0);
                result.put("todaySignBonusNum", 0);
            }
        }
        catch (Exception e) {
            result.put("seriesSignDays", 0);
            result.put("sumSignDays", 0);
            result.put("isSign", false);
            result.put("totalSignBonusNum", 0);
            result.put("todaySignIndex", 0);
            result.put("msg", "\u7b7e\u5230\u5929\u6570\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38");
            logger.error("\u7528\u6237[" + userId + "]\u67e5\u8be2\u7b7e\u5230\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private boolean isTodayOrderYesSign(SignRecord signRecord) {
        Date now = new Date();
        String today = sdf.format(now);
        if (today.equals(signRecord.getSignDate())) {
            return true;
        }
        Date yes = new Date(now.getTime() - 86400000L);
        String yesShort = sdf.format(yes);
        return yesShort.equals(signRecord.getSignDate());
    }

    private boolean isTodayOrderSign(SignRecord signRecord) {
        Date now = new Date();
        String today = sdf.format(now);
        return today.equals(signRecord.getSignDate());
    }

    public void getPrizeNum(Map<String, Object> result, String userId) {
        GiftRecordQueryTime giftRecordQueryTime = FacadeFactory.INSTANCE.getBaseSo().findById(GiftRecordQueryTime.class, userId);
        GiftRecord query = new GiftRecord();
        query.setIsShow(true);
        query.setUserId(userId);
        String fromRecordTime = giftRecordQueryTime == null ? "2013-12-09" : giftRecordQueryTime.getLastQueryTime();
        query.setFromRecordTime(fromRecordTime);
        int prizeNum = FacadeFactory.INSTANCE.getBaseSo().countObject(query);
        result.put("prizeNum", prizeNum);
    }
}

