/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.bonus;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.channel.vo.UserEntitry;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.so.bonus.AuctionRecordSo;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionRecord;
import com.xunlei.niux.data.vipgame.vo.bonus.BaseProduct;
import com.xunlei.util.Log;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class AuctionRecordCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(AuctionRecordCmd.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @CmdMapper(value={"/bonus/getauctionproduct.do"})
    public Object getAuctionProduct(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            long auctionProductId = request.getParameterLong("auctionProductId", -1L);
            AuctionProduct auctionProduct = FacadeFactory.INSTANCE.getAuctionProductBo().findOne(auctionProductId);
            resultMap.put("code", "00");
            if (auctionProduct != null) {
                resultMap.put("productName", auctionProduct.getProductName() == null ? "" : auctionProduct.getProductName());
                resultMap.put("baseBonusNum", auctionProduct.getBaseBonusNum());
                resultMap.put("oneAddBonusNum", auctionProduct.getOneAddBonusNum());
                resultMap.put("startAuctionTime", auctionProduct.getStartAuctionTime());
                resultMap.put("endAuctionTime", auctionProduct.getEndAuctionTime());
                resultMap.put("auctionProductNum", auctionProduct.getAuctionProductNum());
                resultMap.put("auctionTimes", auctionProduct.getAuctionTimes());
                resultMap.put("systemTime", sdf.format(new Date()));
                resultMap.put("auctionProductId", auctionProduct.getAuctionProductId());
                resultMap.put("picUrl", auctionProduct.getPicUrl() == null ? "" : auctionProduct.getPicUrl());
                resultMap.put("detailedDesc", auctionProduct.getDetailedDesc() == null ? "" : auctionProduct.getDetailedDesc());
            } else {
                resultMap.put("code", "1015");
            }
        }
        catch (Exception e) {
            resultMap.put("code", "99");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    @CmdMapper(value={"/bonus/getauctiontimes.do"})
    public Object getAuctionTimes(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            String auctionProductIdsString = request.getParameter("auctionProductIds", "");
            String[] auctionProductIds = auctionProductIdsString.split("_");
            if (auctionProductIds == null || auctionProductIds.length == 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
            }
            ArrayList resultList = new ArrayList();
            for (String auctionProductId : auctionProductIds) {
                AuctionProduct auctionProduct;
                if (auctionProductId == null || "".equals(auctionProductId) || (auctionProduct = FacadeFactory.INSTANCE.getAuctionProductBo().findOne(Long.valueOf(auctionProductId))) == null) continue;
                HashMap<String, Number> map = new HashMap<String, Number>();
                map.put("auctionProductId", auctionProduct.getAuctionProductId());
                map.put("auctionTimes", auctionProduct.getAuctionTimes());
                resultList.add(map);
            }
            resultMap.put("auctionTimeInfos", resultList);
            resultMap.put("systemTime", sdf.format(new Date()));
            resultMap.put("code", "00");
        }
        catch (Exception e) {
            resultMap.put("code", "99");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    @CmdMapper(value={"/bonus/getmylatestauctionrecord.do"})
    public Object getMyLatestAuctionRecord(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            long auctionProductId = request.getParameterLong("auctionProductId", -1L);
            AuctionRecord query = new AuctionRecord();
            query.setUserId(mainParam.getUserid() + "");
            query.setAuctionProductId(auctionProductId);
            query.setIsValid(true);
            Page page = new Page();
            page.setPageNo(1);
            page.setPageSize(1);
            page.addOrder("auctionTime", OrderType.DESC);
            List<AuctionRecord> list = FacadeFactory.INSTANCE.getAuctionRecordBo().finds(query, page);
            AuctionRecord userlatestMyLateRecord = list == null || list.size() == 0 ? null : list.get(0);
            resultMap.put("code", "00");
            if (userlatestMyLateRecord != null) {
                String nickName = this.getNickName(userlatestMyLateRecord.getUserName());
                resultMap.put("nickName", nickName == null || "".equals(nickName) ? "" : userlatestMyLateRecord.getUserName());
                resultMap.put("auctionTime", userlatestMyLateRecord.getAuctionTime());
                resultMap.put("bonusNum", userlatestMyLateRecord.getBonusNum());
                resultMap.put("auctionProductId", userlatestMyLateRecord.getAuctionProductId());
                resultMap.put("auctionNo", userlatestMyLateRecord.getAuctionNo());
                AuctionProduct product = FacadeFactory.INSTANCE.getAuctionProductBo().findOne(userlatestMyLateRecord.getAuctionProductId());
                resultMap.put("isSelectFenQu", product.getIsSelectFenQu() != false ? "1" : "0");
                resultMap.put("isSelectRole", product.getIsSelectRole() != false ? "1" : "0");
                resultMap.put("productName", product.getProductName());
                resultMap.put("giveOutStatus", userlatestMyLateRecord.getGiveOutProductStatus());
                resultMap.put("acutionStatus", AuctionRecordCmd.changeStatus(product, userlatestMyLateRecord));
                resultMap.put("gameId", product.getGameId() == null ? "" : product.getGameId());
                int status = AuctionRecordCmd.auctionProductStatus(product);
                if (status == 2 && "2".equals(userlatestMyLateRecord.getGiveOutProductStatus())) {
                    BaseProduct bp = FacadeFactory.INSTANCE.getBaseProductBo().findOne(product.getBaseProductId());
                    resultMap.put("successTips", bp.getSuccessTip() == null ? "" : bp.getSuccessTip());
                    resultMap.put("successTipLink", bp.getSuccessTiplink() == null ? "" : bp.getSuccessTiplink());
                    resultMap.put("giveOutType", bp.getGiveOutType());
                    resultMap.put("serialnumber", userlatestMyLateRecord.getSerialNum() == null ? "" : userlatestMyLateRecord.getSerialNum());
                }
            } else {
                resultMap.put("code", "99");
                resultMap.put("msg", "\u6ca1\u6709\u51fa\u4ef7\u8bb0\u5f55");
            }
        }
        catch (Exception e) {
            resultMap.put("code", "99");
            resultMap.put("msg", e.getMessage());
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    @CmdMapper(value={"/bonus/getauctionrecords.do"})
    public Object getAuctionRecords(XLHttpRequest request, XLHttpResponse response) {
        long auctionProductId = request.getParameterLong("auctionProductId", -1L);
        int pageSize = request.getParameterInteger("pageSize", 10);
        int pageNo = request.getParameterInteger("pageNo", 1);
        AuctionRecord query = new AuctionRecord();
        query.setAuctionProductId(auctionProductId);
        query.setIsValid(true);
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("bonusNum", OrderType.DESC);
        page.addOrder("auctionTime", OrderType.ESC);
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        int count = FacadeFactory.INSTANCE.getAuctionRecordBo().count(query);
        resultMap.put("count", Integer.valueOf(count));
        ArrayList resultList = new ArrayList();
        List<AuctionRecord> arList = FacadeFactory.INSTANCE.getAuctionRecordBo().finds(query, page);
        for (AuctionRecord ar : arList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String nickName = this.getNickName(ar.getUserName());
            map.put("nickName", nickName == null || "".equals(nickName) ? ar.getUserName() : nickName);
            map.put("auctionTime", ar.getAuctionTime());
            map.put("bonusNum", ar.getBonusNum());
            AuctionProduct product = FacadeFactory.INSTANCE.getAuctionProductBo().findOne(ar.getAuctionProductId());
            map.put("acutionStatus", AuctionRecordCmd.changeStatus(product, ar));
            map.put("auctionProductId", ar.getAuctionProductId());
            resultList.add(map);
        }
        resultMap.put("records", resultList);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    @CmdMapper(value={"/bonus/getuserauctionbonusinfo.do"})
    public Object getUserAuctionBonusInfo(XLHttpRequest request, XLHttpResponse response) {
        long auctionProductId = request.getParameterLong("auctionProductId", -1L);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            int lockBonusNum;
            MainParam mainParam = this.getMainParam(request, response, true);
            AuctionProduct auctionProduct = FacadeFactory.INSTANCE.getAuctionProductBo().findOne(auctionProductId);
            resultMap.put("baseBonusNum", auctionProduct.getBaseBonusNum());
            resultMap.put("oneAddBonusNum", auctionProduct.getOneAddBonusNum());
            int nextAuctionBonusNum = auctionProduct.getBaseBonusNum();
            nextAuctionBonusNum = auctionProduct.getAuctionProductNum() > auctionProduct.getBiddedUserNum() ? auctionProduct.getBaseBonusNum() : auctionProduct.getBiddedMinBonusNum() + auctionProduct.getOneAddBonusNum();
            String userId = mainParam.getUserid() + "";
            AuctionRecord userlateAuctionRecord = FacadeFactory.INSTANCE.getAuctionRecordBo().getUserLastValidAuctionRecord(userId, auctionProductId);
            int n = lockBonusNum = userlateAuctionRecord == null || userlateAuctionRecord.getBonusNum() == null ? 0 : userlateAuctionRecord.getBonusNum();
            if (lockBonusNum >= nextAuctionBonusNum) {
                nextAuctionBonusNum = lockBonusNum + auctionProduct.getOneAddBonusNum();
            }
            resultMap.put("nextAuctionBonusNum", nextAuctionBonusNum);
            BonusClient.UserBonus userBonus = BonusClient.queryBonus(userId);
            int canAuctionBonusNum = lockBonusNum;
            if (userBonus != null) {
                canAuctionBonusNum += userBonus.getBonusNum().intValue();
            }
            resultMap.put("canAuctionBonusNum", canAuctionBonusNum);
            resultMap.put("code", "00");
        }
        catch (Exception e) {
            resultMap.put("code", "99");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    @CmdMapper(value={"/bonus/auction.do"})
    public Object auction(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        MainParam mainParam = null;
        try {
            mainParam = this.getMainParam(request, response, true);
        }
        catch (Exception e) {
            resultMap.put("code", "19");
            resultMap.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        AuctionRecord record = new AuctionRecord();
        record.setUserId(mainParam.getUserid() + "");
        record.setUserName(this.getUserName(request));
        record.setAuctionIp("127.0.0.1");
        record.setAuctionProductId(request.getParameterLong("auctionProductId"));
        record.setBonusNum(request.getParameterInteger("bonusNum"));
        record.setActNo("auctionbonus");
        try {
            new AuctionRecordSo().auction(record);
            resultMap.put("code", "00");
        }
        catch (NiuRuntimeException e) {
            resultMap.put("code", e.code);
            resultMap.put("msg", e.getMessage());
            logger.error("aution fail userid[" + record.getUserId() + "]product[" + record.getAuctionProductId() + "]");
        }
        catch (Exception e) {
            resultMap.put("code", "99");
            resultMap.put("msg", e.getMessage());
            logger.error("aution fail userid[" + record.getUserId() + "]product[" + record.getAuctionProductId() + "]");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    private String getNickName(String userName) {
        try {
            UserEntitry userEntitry = UserUtility.getUserEntitryByUserName(userName);
            return userEntitry.getNickname();
        }
        catch (Exception e) {
            return "";
        }
    }

    @CmdMapper(value={"/bonus/exchangeauctionproduct.do"})
    public Object exchangeAuctionProduct(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String auctionNo = request.getParameter("auctionNo", "");
            String userId = mainParam.getUserid() + "";
            String serverId = request.getParameter("serverId", "0");
            String roleId = request.getParameter("roleId", "");
            if ("".equals(auctionNo)) {
                throw new NiuRuntimeException("13", "\u53c2\u6570\u9519\u8bef");
            }
            AuctionRecord record = FacadeFactory.INSTANCE.getAuctionRecordBo().findOne(auctionNo);
            if (record == null || !record.getIsValid().booleanValue() || !record.getIsBidded().booleanValue()) {
                throw new NiuRuntimeException("1055", "\u7ade\u62cd\u7f16\u53f7[" + auctionNo + "]\u5bf9\u5e94\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            if (!"2".equals(record.getBonusStatus())) {
                throw new NiuRuntimeException("1051", "\u7ade\u62cd\u7f16\u53f7[" + auctionNo + "]\u5bf9\u5e94\u8bb0\u5f55\u672a\u53e3\u79ef\u5206");
            }
            if (!userId.equals(record.getUserId())) {
                throw new NiuRuntimeException("99", "UID\u4e0d\u4e00\u81f4");
            }
            if ("2".equals(record.getGiveOutProductStatus())) {
                AuctionProduct product = FacadeFactory.INSTANCE.getAuctionProductBo().findOne(record.getAuctionProductId());
                BaseProduct bp = FacadeFactory.INSTANCE.getBaseProductBo().findOne(product.getBaseProductId());
                resultMap.put("code", "00");
                resultMap.put("successTips", bp.getSuccessTip() == null ? "" : bp.getSuccessTip());
                resultMap.put("successTipLink", bp.getSuccessTiplink() == null ? "" : bp.getSuccessTiplink());
                resultMap.put("giveOutType", bp.getGiveOutType());
                resultMap.put("serialnumber", record.getSerialNum());
                return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
            }
            long timestamp = FacadeFactory.INSTANCE.getAuctionRecordBo().updateTimestamp(record.getSeqId());
            AuctionProduct product = FacadeFactory.INSTANCE.getAuctionProductBo().findOne(record.getAuctionProductId());
            boolean isEnd = AuctionRecordSo.checkAuctionEnd(product);
            if (!isEnd) {
                throw new NiuRuntimeException("1056", "\u7ade\u62cd\u672a\u7ed3\u675f");
            }
            if (product.getIsSelectFenQu().booleanValue() && "".equals(serverId)) {
                throw new NiuRuntimeException("1057", "\u672a\u9009\u533a");
            }
            if (product.getIsSelectFenQu().booleanValue() && product.getIsSelectRole().booleanValue() && "".equals(roleId)) {
                throw new NiuRuntimeException("1058", "\u672a\u9009\u89d2\u8272");
            }
            record = FacadeFactory.INSTANCE.getAuctionRecordBo().findOne(auctionNo);
            if (timestamp != record.getTimestamp()) {
                throw new NiuRuntimeException("1059", "\u5151\u6362\u592a\u9891\u7e41");
            }
            record.setRoleId(roleId);
            record.setServerId(serverId);
            FacadeFactory.INSTANCE.getAuctionRecordBo().update(record);
            record = AuctionRecordSo.giveOutProduct(record, product);
            BaseProduct bp = FacadeFactory.INSTANCE.getBaseProductBo().findOne(product.getBaseProductId());
            resultMap.put("code", "00");
            resultMap.put("successTips", bp.getSuccessTip() == null ? "" : bp.getSuccessTip());
            resultMap.put("successTipLink", bp.getSuccessTiplink() == null ? "" : bp.getSuccessTiplink());
            resultMap.put("giveOutType", bp.getGiveOutType());
            resultMap.put("serialnumber", record.getSerialNum());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        catch (NiuRuntimeException e) {
            logger.error("\u9886\u53d6\u5931\u8d25\uff1a", e);
            resultMap.put("code", e.code);
            resultMap.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        catch (Exception e) {
            logger.error("\u9886\u53d6\u5931\u8d25\uff1a", e);
            resultMap.put("code", "19");
            resultMap.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
    }

    private static int auctionProductStatus(AuctionProduct auctionProduct) {
        String nowStr = sdf.format(new Date());
        if (auctionProduct.getStartAuctionTime().compareTo(nowStr) > 0) {
            return 0;
        }
        if (auctionProduct.getEndAuctionTime().compareTo(nowStr) > 0) {
            return 1;
        }
        return 2;
    }

    private static String changeStatus(AuctionProduct product, AuctionRecord record) {
        int productStatus = AuctionRecordCmd.auctionProductStatus(product);
        if (productStatus == 2 && record.getIsBidded().booleanValue()) {
            return "3";
        }
        if (productStatus == 2 && !record.getIsBidded().booleanValue()) {
            return "2";
        }
        return record.getIsBidded() != false ? "1" : "0";
    }
}

