/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.bigact;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.ActivityConstant;
import com.xunlei.niux.center.util.ActivityUtil;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.active.vo.BigAct;
import com.xunlei.util.Log;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BigActVoteInfoCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(BigActVoteInfoCmd.class);
    private static List<VoteInfo> rankList;

    @CmdMapper(value={"/bigact/getVoteInfo.do"})
    public Object getVoteInfo(XLHttpRequest request, XLHttpResponse response) {
        try {
            BigAct bigAct = new BigAct();
            Page page = new Page(0, 0);
            List<BigAct> list = FacadeFactory.INSTANCE.getBigActBo().find(bigAct, page);
            HashMap<String, VoteInfo> map = new HashMap<String, VoteInfo>();
            for (BigAct temp : list) {
                map.put(temp.getPlayerno(), new VoteInfo(temp.getGameid(), temp.getPlayerno(), temp.getVotenum()));
            }
            if (rankList == null) {
                rankList = this.getRank();
                this.updateTask();
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("info", map);
            result.put("rank", rankList);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("\u62bd\u5956\u63a5\u53e3\u5f02\u5e38", e);
            return this.error("\u7f51\u7edc\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    private void updateTask() {
        String hour = DateUtil.formatNow("HH");
        String beginTime = hour.compareTo("12") < 0 ? DateUtil.formatNow("yyyy-MM-dd") : DateUtil.format(DateUtil.tomorrow(), "yyyy-MM-dd");
        Date beginDate = null;
        try {
            beginDate = DateUtil.parseByDefault(beginTime + " 12:00:00");
        }
        catch (ParseException e) {
            logger.error("\u65f6\u95f4\u8f6c\u5316\u5f02\u5e38", e);
        }
        long period = 86400000L;
        final Timer timer = new Timer("updateRank");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    rankList = BigActVoteInfoCmd.this.getRank();
                    if (ActivityUtil.getActStatus(ActivityConstant.BIG_ACT_NO) >= 2) {
                        timer.cancel();
                    }
                }
                catch (Exception e) {
                    logger.error("\u5b9a\u65f6\u66f4\u65b0\u5927\u5168\u6d3b\u52a8\u6392\u884c\u4efb\u52a1\u5f02\u5e38", e);
                }
            }
        }, beginDate, period);
    }

    private List<VoteInfo> getRank() {
        BigAct bigAct = new BigAct();
        Page page = new Page(1, 3);
        page.addOrder("votenum", OrderType.DESC);
        ArrayList<VoteInfo> list = new ArrayList<VoteInfo>();
        for (BigAct temp : FacadeFactory.INSTANCE.getBigActBo().find(bigAct, page)) {
            list.add(new VoteInfo(temp.getGameid(), temp.getPlayerno(), temp.getVotenum()));
        }
        return list;
    }

    private String error(String errmsg) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("msg", errmsg);
        return JsonObjectUtil.getRtnAndDataJsonObject(1, error);
    }

    private static class VoteInfo {
        private String gameid;
        private String playerno;
        private Long votenum;

        private VoteInfo(String gameid, String playerno, Long votenum) {
            this.gameid = gameid;
            this.playerno = playerno;
            this.votenum = votenum;
        }

        public String getPlayerno() {
            return this.playerno;
        }

        public void setPlayerno(String playerno) {
            this.playerno = playerno;
        }

        public Long getVotenum() {
            return this.votenum;
        }

        public void setVotenum(Long votenum) {
            this.votenum = votenum;
        }

        public String getGameid() {
            return this.gameid;
        }

        public void setGameid(String gameid) {
            this.gameid = gameid;
        }
    }
}

