/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.bigact;

import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.ActivityConstant;
import com.xunlei.niux.center.util.ActivityUtil;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.data.active.bo.BigActVoteBo;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.active.vo.BigActVote;
import com.xunlei.util.Log;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BigActVoteCmd
extends DefaultCmd {
    private static final int DAY_MAX_USER_NUM = 3;
    private static final int DAY_MAX_IP_NUM = 10;
    private static Logger logger = Log.getLogger(BigActVoteCmd.class);

    @CmdMapper(value={"/bigact/vote.do"})
    public Object vote(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String userid = String.valueOf(mainParam.getUserid());
            String nickname = URLDecoder.decode(request.getCookieValue("usernick", ""), "UTF-8");
            if ("".equals(nickname)) {
                nickname = mainParam.getUserAccount();
            }
            String userip = request.getRemoteIP();
            String playerno = request.getParameter("playerno");
            if (StringUtil.isEmpty(playerno)) {
                return this.error("\u7f3a\u5c11\u53c2\u6570");
            }
            if (Integer.parseInt(playerno) <= 0 && Integer.parseInt(playerno) > 24) {
                return this.error("\u53c2\u6570\u65e0\u6548");
            }
            int status = ActivityUtil.getActStatus(ActivityConstant.BIG_ACT_NO);
            if (status <= 0) {
                return this.error("\u6d3b\u52a8\u8fd8\u6ca1\u5f00\u59cb\uff0c\u656c\u8bf7\u5173\u6ce8\u3002");
            }
            if (status >= 2) {
                return this.error("\u62b1\u6b49\uff0c\u672c\u6b21\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f\uff0c\u8bf7\u53c2\u52a0\u6211\u4eec\u7684\u5176\u5b83\u6d3b\u52a8\uff01");
            }
            BigActVoteBo bigActVoteBo = FacadeFactory.INSTANCE.getBigActVoteBo();
            BigActVote tempVote = new BigActVote();
            tempVote.setUserip(userip);
            tempVote.setFromVotetime(DateUtil.formatNow("yyyy-MM-dd") + " 00:00:00");
            tempVote.setTovotetime(DateUtil.format(DateUtil.tomorrow(), "yyyy-MM-dd") + " 00:00:00");
            Page tempPage = new Page(1, 10);
            List<BigActVote> list = bigActVoteBo.find(tempVote, tempPage);
            if (list.size() >= 10) {
                return this.error("\u60a8\u8bbf\u95ee\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u660e\u5929\u518d\u6765\u6295\u7968\u5427!");
            }
            List<BigActVote> bigActVotes = this.getVoteByDay(userid);
            int userVoteNum = bigActVotes.size();
            if (userVoteNum >= 3) {
                return this.error("\u975e\u5e38\u62b1\u6b49\uff0c\u60a8\u4eca\u5929\u5df2\u7ecf\u6295\u8fc73\u6b21\u7968\uff0c\u8bf7\u660e\u5929\u518d\u6765\u3002");
            }
            if (userVoteNum > 0) {
                String endTime = bigActVotes.get(userVoteNum - 1).getVotetime();
                long time = new Date().getTime() - DateUtil.parseByDefault(endTime).getTime();
                if (time < 600000L) {
                    return this.error("\u975e\u5e38\u62b1\u6b49\uff0c\u8ddd\u79bb\u60a8\u4e0a\u6b21\u6295\u7968\u4e0d\u8db310\u5206\u949f\uff0c\u8bf7\u7a0d\u540e\u518d\u4e3a\u559c\u6b22\u7684\u7f8e\u5973\u6295\u7968\u3002");
                }
            }
            tempVote = new BigActVote();
            tempVote.setUserid(userid);
            tempVote.setNickname(nickname);
            tempVote.setVotetime(DateUtil.formatNowByDefault());
            tempVote.setPlayerno(playerno);
            tempVote.setUserip(userip);
            bigActVoteBo.insert(tempVote);
            this.updateBigActNum(playerno);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("leftvotenum", 3 - userVoteNum - 1);
            data.put("playerno", playerno);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
        }
        catch (Exception e) {
            logger.error("\u5927\u5168\u6d3b\u52a8\u6295\u7968\u5f02\u5e38", e);
            return this.error("\u7f51\u7edc\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    private void updateBigActNum(String playerno) {
        String sql = "update t_bigact_info set votenum = votenum + 1 where playerno = ?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(playerno);
        FacadeFactory.INSTANCE.getBigActBo().execute(sql, params);
    }

    private List<BigActVote> getVoteByDay(String userid) {
        BigActVote tempVote = new BigActVote();
        tempVote.setUserid(userid);
        tempVote.setFromVotetime(DateUtil.formatNow("yyyy-MM-dd") + " 00:00:00");
        tempVote.setTovotetime(DateUtil.format(DateUtil.tomorrow(), "yyyy-MM-dd") + " 00:00:00");
        Page tempPage = new Page(1, 3);
        return FacadeFactory.INSTANCE.getBigActVoteBo().find(tempVote, tempPage);
    }

    private String error(String errmsg) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("msg", errmsg);
        return JsonObjectUtil.getRtnAndDataJsonObject(1, error);
    }
}

