/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.bigact;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.bigact.BigActPrizeEnum;
import com.xunlei.niux.center.util.ActivityConstant;
import com.xunlei.niux.center.util.ActivityUtil;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.active.vo.BigActPrize;
import com.xunlei.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BigActPrizeListCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(BigActPrizeListCmd.class);
    private static List<GetPrizeInfo> prizeList;

    @CmdMapper(value={"/bigact/getPrizeList.do"})
    public Object getPrizeList(XLHttpRequest request, XLHttpResponse response) {
        try {
            if (prizeList == null) {
                prizeList = this.getPrizeLists();
                this.updateTask();
            }
            HashMap<String, List<GetPrizeInfo>> result = new HashMap<String, List<GetPrizeInfo>>();
            result.put("prizeList", prizeList);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("\u62bd\u5956\u63a5\u53e3\u5f02\u5e38", e);
            return this.error("\u7f51\u7edc\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    private void updateTask() {
        long period = 300000L;
        final Timer timer = new Timer("getPrizeList");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    prizeList = BigActPrizeListCmd.this.getPrizeLists();
                    if (ActivityUtil.getActStatus(ActivityConstant.BIG_ACT_NO) >= 2) {
                        timer.cancel();
                    }
                }
                catch (Exception e) {
                    logger.error("\u5b9a\u65f6\u66f4\u65b0\u5927\u5168\u62bd\u5956\u540d\u5355\u5f02\u5e38", e);
                }
            }
        }, period, period);
    }

    private List<GetPrizeInfo> getPrizeLists() {
        BigActPrize bigActPrize = new BigActPrize();
        bigActPrize.setPrizetype(BigActPrizeEnum.ONE.name());
        Page page = new Page(1, 10);
        page.addOrder("prizetime", OrderType.DESC);
        ArrayList<GetPrizeInfo> list = new ArrayList<GetPrizeInfo>();
        for (BigActPrize temp : FacadeFactory.INSTANCE.getBigActPrizeBo().find(bigActPrize, page)) {
            list.add(new GetPrizeInfo(temp.getNickname(), BigActPrizeEnum.valueOf(temp.getPrizetype()).getPrizeId()));
        }
        bigActPrize = new BigActPrize();
        bigActPrize.setPrizetype(BigActPrizeEnum.VIP_HALF_YEAR.name());
        page.setPageSize(2);
        for (BigActPrize temp : FacadeFactory.INSTANCE.getBigActPrizeBo().find(bigActPrize, page)) {
            list.add(new GetPrizeInfo(temp.getNickname(), BigActPrizeEnum.valueOf(temp.getPrizetype()).getPrizeId()));
        }
        bigActPrize = new BigActPrize();
        bigActPrize.setPrizetype(BigActPrizeEnum.TWO.name());
        page.setPageSize(6);
        for (BigActPrize temp : FacadeFactory.INSTANCE.getBigActPrizeBo().find(bigActPrize, page)) {
            list.add(new GetPrizeInfo(temp.getNickname(), BigActPrizeEnum.valueOf(temp.getPrizetype()).getPrizeId()));
        }
        bigActPrize = new BigActPrize();
        bigActPrize.setPrizetype(BigActPrizeEnum.VIP_QUARTER_YEAR.name());
        page.setPageSize(3);
        for (BigActPrize temp : FacadeFactory.INSTANCE.getBigActPrizeBo().find(bigActPrize, page)) {
            list.add(new GetPrizeInfo(temp.getNickname(), BigActPrizeEnum.valueOf(temp.getPrizetype()).getPrizeId()));
        }
        bigActPrize = new BigActPrize();
        bigActPrize.setPrizetype(BigActPrizeEnum.THREE.name());
        page.setPageSize(4);
        for (BigActPrize temp : FacadeFactory.INSTANCE.getBigActPrizeBo().find(bigActPrize, page)) {
            list.add(new GetPrizeInfo(temp.getNickname(), BigActPrizeEnum.valueOf(temp.getPrizetype()).getPrizeId()));
        }
        bigActPrize = new BigActPrize();
        bigActPrize.setPrizetype(BigActPrizeEnum.BAIJING_VIP_MONTH.name());
        page.setPageSize(5);
        for (BigActPrize temp : FacadeFactory.INSTANCE.getBigActPrizeBo().find(bigActPrize, page)) {
            list.add(new GetPrizeInfo(temp.getNickname(), BigActPrizeEnum.valueOf(temp.getPrizetype()).getPrizeId()));
        }
        Collections.shuffle(list);
        return list;
    }

    private String error(String errmsg) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("msg", errmsg);
        return JsonObjectUtil.getRtnAndDataJsonObject(1, error);
    }

    private static class GetPrizeInfo {
        private String nickname;
        private Integer prizetype;

        private GetPrizeInfo(String nickname, Integer prizetype) {
            this.nickname = nickname;
            this.prizetype = prizetype;
        }

        public String getNickname() {
            return this.nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public Integer getPrizetype() {
            return this.prizetype;
        }

        public void setPrizetype(Integer prizetype) {
            this.prizetype = prizetype;
        }
    }
}

