/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.bigact;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.center.util.VipUtil;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.active.vo.BigActPrize;
import java.util.Calendar;
import java.util.List;
import java.util.Random;

public enum BigActPrizeEnum {
    START(0),
    ONE(3000, START, "1\u5143\u4ee3\u91d1\u5238", 6, VipUtil.SendType.CASH, "11"),
    TWO(2000, ONE, "2\u5143\u4ee3\u91d1\u5238", 4, VipUtil.SendType.CASH, "12"),
    THREE(1000, TWO, "3\u5143\u4ee3\u91d1\u5238", 1, VipUtil.SendType.CASH, "13"),
    BAIJING_VIP_MONTH(5, THREE, "\u767d\u91d1\u4f1a\u5458\u6708\u5361", 60, 5, 5, VipUtil.SendType.BAIJIN, "1"),
    VIP_QUARTER_YEAR(2, BAIJING_VIP_MONTH, "\u5b63\u5361", 24, 2, 3, VipUtil.SendType.BAIJIN, "2"),
    VIP_HALF_YEAR(1, VIP_QUARTER_YEAR, "\u534a\u5e74\u5361", 12, 1, 7, VipUtil.SendType.BAIJIN, "3"),
    VIP_YEAR(0, VIP_HALF_YEAR, "\u5e74\u5361", 2, 8, VipUtil.SendType.BAIJIN, "4"),
    WELCOME(3992, VIP_YEAR, "\u8c22\u8c22\u53c2\u4e0e", 2, null, null);

    private int num;
    private BigActPrizeEnum prePrize;
    private String message;
    private int dayLimitNum;
    private int hourLimitNum;
    private int prizeId;
    private VipUtil.SendType sendType;
    private String item;

    private BigActPrizeEnum(int num) {
        this.num = num;
    }

    private BigActPrizeEnum(int num, BigActPrizeEnum prePrize, String message, int prizeId, VipUtil.SendType sendType, String item) {
        this(num, prePrize, message, 0, prizeId, sendType, item);
    }

    private BigActPrizeEnum(int num, BigActPrizeEnum prePrize, String message, int dayLimitNum, int prizeId, VipUtil.SendType sendType, String item) {
        this(num, prePrize, message, dayLimitNum, 0, prizeId, sendType, item);
    }

    private BigActPrizeEnum(int num, BigActPrizeEnum prePrize, String message, int dayLimitNum, int hourLimitNum, int prizeId, VipUtil.SendType sendType, String item) {
        this.num = num;
        this.prePrize = prePrize;
        this.message = message;
        this.dayLimitNum = dayLimitNum;
        this.hourLimitNum = hourLimitNum;
        this.prizeId = prizeId;
        this.sendType = sendType;
        this.item = item;
    }

    public BigActPrizeEnum getPrePrize() {
        return this.prePrize;
    }

    public int getNum() {
        return this.num;
    }

    public int getPrizeId() {
        return this.prizeId;
    }

    public int getStartNum() {
        if (this.getPrePrize() == null) {
            return 0;
        }
        return this.getPrePrize().getNum() + this.getPrePrize().getStartNum();
    }

    public int getEndNum() {
        return this.num + this.getStartNum();
    }

    public String getMessage() {
        return this.message;
    }

    public int getDayLimitNum() {
        return this.dayLimitNum;
    }

    public int getHourLimitNum() {
        return this.hourLimitNum;
    }

    public VipUtil.SendType getSendType() {
        return this.sendType;
    }

    public String getItem() {
        return this.item;
    }

    public static BigActPrizeEnum getPrize(BigActPrize actPrize) {
        Random random = new Random();
        int num = WELCOME.getEndNum();
        BigActPrizeEnum prizeEnum = BigActPrizeEnum.getPrizeByNum(random.nextInt(num));
        if (prizeEnum.getDayLimitNum() > 0) {
            return BigActPrizeEnum.getPrizeByNumByDayLimint(prizeEnum, actPrize);
        }
        BigActPrizeEnum.logPrize(actPrize, prizeEnum);
        return prizeEnum;
    }

    private static BigActPrizeEnum getPrizeByNum(int num) {
        BigActPrizeEnum prize = WELCOME;
        for (BigActPrizeEnum tempPrize : BigActPrizeEnum.values()) {
            if (num < tempPrize.getStartNum() || num >= tempPrize.getEndNum()) continue;
            prize = tempPrize;
            break;
        }
        return prize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigActPrizeEnum getPrizeByNumByDayLimint(BigActPrizeEnum tempPrize, BigActPrize actPrize) {
        BigActPrize bigActPrize = new BigActPrize();
        bigActPrize.setPrizetype(tempPrize.name());
        bigActPrize.setFromPrizeTime(DateUtil.formatNow("yyyy-MM-dd") + " 00:00:00");
        bigActPrize.setToPrizeTime(DateUtil.format(DateUtil.tomorrow(), "yyyy-MM-dd") + " 00:00:00");
        Page tempPage = new Page(1, tempPrize.getDayLimitNum());
        BigActPrizeEnum reslut = WELCOME;
        BigActPrizeEnum bigActPrizeEnum = tempPrize;
        synchronized (bigActPrizeEnum) {
            List<BigActPrize> bigActPrizeList = FacadeFactory.INSTANCE.getBigActPrizeBo().find(bigActPrize, tempPage);
            if (bigActPrizeList.size() < tempPrize.getDayLimitNum()) {
                if (tempPrize.getHourLimitNum() > 0) {
                    int hourNum = 0;
                    String startHour = DateUtil.formatNow("yyyy-MM-dd HH") + ":00:00";
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(11, 1);
                    String endHour = DateUtil.format(calendar.getTime(), "yyyy-MM-dd HH") + ":00:00";
                    for (BigActPrize temp : bigActPrizeList) {
                        String prizeTime = temp.getPrizetime();
                        if (prizeTime.compareTo(startHour) < 0 || prizeTime.compareTo(endHour) >= 0) continue;
                        ++hourNum;
                    }
                    if (hourNum < tempPrize.getHourLimitNum()) {
                        reslut = tempPrize;
                    }
                } else {
                    reslut = tempPrize;
                }
            }
            BigActPrizeEnum.logPrize(actPrize, reslut);
        }
        return reslut;
    }

    private static void logPrize(BigActPrize bigActPrize, BigActPrizeEnum prizeEnum) {
        bigActPrize.setPrizetime(DateUtil.formatNowByDefault());
        bigActPrize.setPrizetype(prizeEnum.name());
        FacadeFactory.INSTANCE.getBigActPrizeBo().insert(bigActPrize);
    }

    public static void main(String[] args) {
        System.out.println(WELCOME.getEndNum());
    }
}

