/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.address;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.enums.ResultCode;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.address.DeliveryAddress;
import com.xunlei.util.Log;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class AddressCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(AddressCmd.class);
    private static DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @CmdMapper(value={"/address/upsertDeliveryAddr.do"})
    public Object upsertDeliveryAddr(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        String seqid = request.getParameter("seqid");
        String addressId = request.getParameter("addressid");
        String userRealName = request.getParameter("userrealname");
        String province = request.getParameter("province");
        String city = request.getParameter("city");
        String district = request.getParameter("district");
        String detailAddress = request.getParameter("detailaddress");
        String postCode = request.getParameter("postcode");
        String telAreaCode = request.getParameter("telareacode");
        String telePhone = request.getParameter("telephone");
        String extensionSet = request.getParameter("extensionset");
        String mobilePhone = request.getParameter("mobilephone");
        String defaultUseStr = request.getParameter("defaultuse");
        String userName = UserUtility.getUserNameByUserId(userId);
        String info = "Current URL: /address/upsertDeliveryAddr.do?";
        if (seqid != null) {
            info = info + "seqid=" + seqid;
        }
        if (addressId != null) {
            info = info + "addressid=" + addressId;
        }
        if (userRealName != null) {
            info = info + "userrealname=" + userRealName;
        }
        if (province != null) {
            info = info + "&province=" + province;
        }
        if (city != null) {
            info = info + "&city=" + city;
        }
        if (district != null) {
            info = info + "&district=" + district;
        }
        if (detailAddress != null) {
            info = info + "&detailaddress=" + detailAddress;
        }
        if (postCode != null) {
            info = info + "&postcode=" + postCode;
        }
        if (telAreaCode != null) {
            info = info + "&telareacode=" + telAreaCode;
        }
        if (telePhone != null) {
            info = info + "&telephone=" + telePhone;
        }
        if (extensionSet != null) {
            info = info + "&extensionset=" + extensionSet;
        }
        if (mobilePhone != null) {
            info = info + "&mobilephone=" + mobilePhone;
        }
        if (defaultUseStr != null) {
            info = info + "&defaultuse=" + defaultUseStr;
        }
        logger.info(info);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(addressId)) {
            sb.append(ResultCode.resultContent.get(ResultCode.INVALIDPARAM) + ": addressId\u4e0d\u80fd\u4e3a\u7a7a");
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.INVALIDPARAM, sb.toString());
        }
        int defaultUse = 0;
        if (StringUtils.isNotEmpty(defaultUseStr) && Integer.parseInt(defaultUseStr) > 0) {
            defaultUse = 1;
        }
        try {
            DeliveryAddress address = null;
            if (StringUtils.isNotEmpty(seqid)) {
                DeliveryAddress query = new DeliveryAddress();
                query.setSeqid(Long.parseLong(seqid));
                address = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            }
            if (StringUtils.isNotEmpty(addressId)) {
                address = this.getAddressByAddressId(addressId);
            }
            if (address == null) {
                address = this.getAddressByUserId(userId);
            }
            boolean addFlag = false;
            if (address == null) {
                addFlag = true;
                address = new DeliveryAddress();
            }
            address.setUserId(userId);
            address.setAddressId(Integer.parseInt(addressId));
            address.setUserName(userName);
            address.setUserRealName(userRealName);
            address.setProvince(province);
            address.setCity(city);
            address.setDistrict(district);
            address.setDetailAddress(detailAddress);
            address.setPostCode(postCode);
            address.setTelephone(telePhone);
            address.setMobilePhone(mobilePhone);
            address.setDefaultUse(defaultUse);
            if (addFlag) {
                address.setRecordTime(sdf_time.format(new Date()));
                FacadeFactory.INSTANCE.getBaseSo().addObject(address);
            } else {
                address.setEditTime(sdf_time.format(new Date()));
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(address);
            }
        }
        catch (Exception e) {
            logger.error("Update DeliveryAddress Error!", e);
            sb.append(ResultCode.resultContent.get(ResultCode.MODIFYDELIVERYADDRESSERROR));
            JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.MODIFYDELIVERYADDRESSERROR, sb.toString());
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, "\u6210\u529f");
    }

    @CmdMapper(value={"/address/getDeliveryAddr.do"})
    public Object getDeliveryAddr(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        StringBuilder sb = new StringBuilder();
        DeliveryAddress query = new DeliveryAddress();
        query.setUserId(userId);
        Page page = new Page();
        page.addOrder("recordTime", OrderType.DESC);
        List<DeliveryAddress> addressList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
        if (CollectionUtils.isEmpty(addressList)) {
            logger.error("getDeliveryAddress: User don't has any delivery address data!");
            sb.append(ResultCode.resultContent.get(ResultCode.NOUSERDELIVERYDATA));
            JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.NOUSERDELIVERYDATA, sb.toString());
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (DeliveryAddress address : addressList) {
            resultList.add(address.toMap());
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, resultList);
    }

    private DeliveryAddress getAddressByAddressId(String addressId) {
        if (StringUtils.isEmpty(addressId)) {
            return null;
        }
        int addrId = Integer.parseInt(addressId);
        DeliveryAddress query = new DeliveryAddress();
        query.setAddressId(addrId);
        Page page = new Page();
        page.addOrder("recordTime", OrderType.DESC);
        List<DeliveryAddress> addressList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
        if (CollectionUtils.isEmpty(addressList)) {
            return null;
        }
        return addressList.get(0);
    }

    private DeliveryAddress getAddressByUserId(String userId) {
        if (StringUtils.isEmpty(userId)) {
            return null;
        }
        DeliveryAddress query = new DeliveryAddress();
        query.setUserId(userId);
        Page page = new Page();
        page.addOrder("recordTime", OrderType.DESC);
        List<DeliveryAddress> addressList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
        if (CollectionUtils.isEmpty(addressList)) {
            return null;
        }
        return addressList.get(0);
    }

    @CmdMapper(value={"/address/getDeliveryAddrId.do"})
    public Object getDeliveryAddrId(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        StringBuilder sb = new StringBuilder();
        DeliveryAddress query = new DeliveryAddress();
        query.setUserId(userId);
        Page page = new Page();
        page.addOrder("recordTime", OrderType.DESC);
        List<DeliveryAddress> addressList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
        if (CollectionUtils.isEmpty(addressList)) {
            logger.error("getDeliveryAddress: User don't has any delivery address data!");
            sb.append(ResultCode.resultContent.get(ResultCode.NOUSERDELIVERYDATA));
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.NOUSERDELIVERYDATA, sb.toString());
        }
        int addrId = 0;
        for (DeliveryAddress addr : addressList) {
            if (addr.getAddressId() <= 0) continue;
            addrId = addr.getAddressId();
            break;
        }
        if (addrId <= 0) {
            logger.error("getDeliveryAddress: User don't has any delivery address data with addressId!");
            sb.append(ResultCode.resultContent.get(ResultCode.NOUSERDELIVERYDATA));
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.NOUSERDELIVERYDATA, sb.toString());
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("addressid", addrId);
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, result);
    }
}

