/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity.secondkill;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.activity.secondkill.ScheduelManager;
import com.xunlei.niux.center.cmd.activity.secondkill.SecondKillBean;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.data.vipgame.dto.activity.SecondKillConfigDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.util.Log;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SecondKillCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(SecondKillCmd.class);

    @CmdMapper(value={"/secondkill/doSecondKill.do"})
    public Object doSecondKill(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        long userId = mainParam.getUserid();
        String remoteIp = request.getRemoteIP();
        logger.info("request URL:{}", (Object)request.getUrl());
        String actNo = request.getParameter("actno");
        String giftId = request.getParameter("giftid");
        if (StringUtils.isEmpty(actNo) || StringUtils.isEmpty(giftId)) {
            logger.error("request:{}, params can't be empty", (Object)request.getUrl());
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u9519\u8bef\uff01");
        }
        ScheduelManager manager = ScheduelManager.getInstance();
        SecondKillBean secondKillBean = manager.getSecondKillBean(actNo);
        if (secondKillBean == null) {
            logger.error("request:{}, secondKillBean is null", (Object)request.getUrl());
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u79d2\u6740\u672a\u5f00\u59cb\uff01");
        }
        boolean result = false;
        try {
            result = secondKillBean.doHandle(userId, giftId, remoteIp);
            if (!result) {
                logger.error("release gift fail!");
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u79d2\u6740\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            logger.error("actNo:{} can't handle now!", (Object)actNo, (Object)e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, e.getMessage());
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u79d2\u6740\u6210\u529f\uff01");
    }

    @CmdMapper(value={"/secondkill/getSecondKillInfo.do"})
    public Object getSecondKillInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String actNo = request.getParameter("actno");
        if (StringUtils.isEmpty(actNo)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SecondKillConfigDTO configDTO = null;
        ScheduelManager manager = ScheduelManager.getInstance();
        SecondKillBean bean = manager.getSecondKillBean(actNo);
        String nextReleaseTimeStr = "";
        boolean onRelease = false;
        if (bean == null) {
            configDTO = manager.getCurSecondKillConfig(actNo);
        } else if (bean.getReleaseFlag().booleanValue()) {
            onRelease = true;
            configDTO = bean.getPreSecondKillConfigDTO();
        } else {
            configDTO = bean.getSecondKillConfigDTO();
        }
        if (configDTO == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u6ca1\u6709\u6d3b\u52a8\u5bf9\u5e94\u7684\u79d2\u6740\u914d\u7f6e\u6570\u636e");
        }
        Gift gift = FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, configDTO.getGiftId());
        if (gift == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-3, "\u6d3b\u52a8\u5bf9\u5e94\u7684\u5956\u54c1\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        nextReleaseTimeStr = onRelease ? DateUtil.getCurDateStr() + " " + configDTO.getReleaseTime() : this.getNextReleaseTimeStr(configDTO.getReleaseTime());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("curTime", DateUtil.formatNowByDefault());
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("releaseCount", configDTO.getReleaseCount());
        configMap.put("releaseTime", nextReleaseTimeStr);
        configMap.put("secondKillMinutes", configDTO.getSecondKillMinutes());
        configMap.put("giftId", configDTO.getGiftId());
        configMap.put("giftName", gift.getGiftName());
        result.put("secondKillInfo", configMap);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
    }

    private String getNextReleaseTimeStr(String timeStr) {
        String releaseTimeStr = DateUtil.getCurDateStr() + " " + timeStr;
        Calendar cal_release = Calendar.getInstance();
        Date releaseTime = null;
        try {
            releaseTime = DateUtil.parseByDefault(releaseTimeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        cal_release.setTime(releaseTime);
        Calendar cal_now = Calendar.getInstance();
        if (cal_release.before(cal_now)) {
            cal_release.add(6, 1);
        }
        String nextReleaseTimeStr = DateUtil.formatByDefault(cal_release.getTime());
        return nextReleaseTimeStr;
    }
}

