/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity.secondkill;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.niux.center.cmd.activity.secondkill.ScheduelManager;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.client.jinzuan.CommonActivityClient;
import com.xunlei.niux.data.vipgame.dto.activity.SecondKillConfigDTO;
import com.xunlei.util.Log;
import com.xunlei.util.concurrent.ConcurrentHashSet;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class SecondKillBean {
    private static Logger logger = Log.getLogger(SecondKillBean.class);
    private String actNo;
    private AtomicBoolean releaseFlag;
    private AtomicInteger releaseCount;
    private SecondKillConfigDTO preSecondKillConfigDTO;
    private SecondKillConfigDTO secondKillConfigDTO;
    private ConcurrentHashSet<Long> userSet;

    public SecondKillBean(String actNo) {
        this.actNo = actNo;
        this.releaseFlag = new AtomicBoolean(false);
        this.releaseCount = new AtomicInteger(0);
        this.userSet = new ConcurrentHashSet();
    }

    public boolean doHandle(long userId, String giftId, String remoteIp) {
        if (!this.releaseFlag.get()) {
            throw new RuntimeException("\u79d2\u6740\u8fd8\u672a\u5f00\u59cb\uff01");
        }
        if (this.userSet.contains(userId)) {
            throw new RuntimeException("\u5df2\u7ecf\u53c2\u4e0e\u8fc7\u672c\u6b21\u79d2\u6740\uff01");
        }
        if (this.secondKillConfigDTO == null) {
            logger.error("member secondKillConfig is null!");
            throw new RuntimeException("\u79d2\u6740\u5931\u8d25\uff01");
        }
        Date startTime = null;
        Date endTime = null;
        Date now = new Date();
        try {
            startTime = DateUtil.parseByDefault(DateUtil.getCurDateStr() + " " + this.secondKillConfigDTO.getReleaseTime());
            endTime = DateUtil.getEndTime(startTime, "minute", this.secondKillConfigDTO.getSecondKillMinutes());
        }
        catch (ParseException e) {
            logger.error("SecondKillBean.doHandle ParseException:", e);
            throw new RuntimeException("\u79d2\u6740\u5931\u8d25!");
        }
        if (this.releaseCount.decrementAndGet() < 0 || now.after(endTime)) {
            this.updateReleaseFlagFalse();
            return false;
        }
        this.userSet.add(userId);
        boolean result = this.releaseGift(userId, giftId, remoteIp);
        return result;
    }

    public boolean releaseGift(long userId, String giftId, String remoteIp) {
        String result = CommonActivityClient.getGift(this.actNo, null, String.valueOf(userId), giftId, remoteIp, false);
        logger.info("CommonActivityClient.getGift \u7684\u7ed3\u679c\u4e3a\uff1a" + result);
        JsonObject jsonObject = new JsonParser().parse(result).getAsJsonObject();
        int code = jsonObject.get("rtn").getAsInt();
        return code == 0;
    }

    private void updateReleaseFlagFalse() {
        this.releaseFlag.compareAndSet(true, false);
        ScheduelManager manager = ScheduelManager.getInstance();
        this.setPreSecondKillConfigDTO(this.secondKillConfigDTO);
        this.setSecondKillConfigDTO(manager.getCurSecondKillConfig(this.actNo));
        this.userSet.clear();
    }

    public Boolean getReleaseFlag() {
        return this.releaseFlag.get();
    }

    public void setReleaseFlag(Boolean releaseFlag) {
        this.releaseFlag.set(releaseFlag);
    }

    public int getReleaseCount() {
        return this.releaseCount.get();
    }

    public void setReleaseCount(int releaseCount) {
        this.releaseCount.set(releaseCount);
    }

    public SecondKillConfigDTO getSecondKillConfigDTO() {
        return this.secondKillConfigDTO;
    }

    public void setSecondKillConfigDTO(SecondKillConfigDTO secondKillConfigDTO) {
        this.secondKillConfigDTO = secondKillConfigDTO;
    }

    public SecondKillConfigDTO getPreSecondKillConfigDTO() {
        return this.preSecondKillConfigDTO;
    }

    public void setPreSecondKillConfigDTO(SecondKillConfigDTO preSecondKillConfigDTO) {
        this.preSecondKillConfigDTO = preSecondKillConfigDTO;
    }
}

