/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity.secondkill;

import com.xunlei.niux.center.cmd.activity.secondkill.SecondKillBean;
import com.xunlei.niux.center.cmd.activity.secondkill.SecondKillJob;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.data.vipgame.dto.activity.SecondKillConfigDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.util.Log;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;

public class ScheduelManager {
    private static Logger logger = Log.getLogger(ScheduelManager.class);
    private static ScheduelManager uniqueInstance;
    private List<SecondKillConfigDTO> allSecKillConfigs;
    private ConcurrentHashMap<String, List<SecondKillConfigDTO>> secKillConfigsMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, SecondKillBean> curConfigMap = new ConcurrentHashMap();

    private ScheduelManager() {
        this.loadConfig();
        this.startJobSchedule();
    }

    public static ScheduelManager getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new ScheduelManager();
        }
        return uniqueInstance;
    }

    public SecondKillBean getSecondKillBean(String actNo) {
        if (this.curConfigMap.containsKey(actNo)) {
            return this.curConfigMap.get(actNo);
        }
        SecondKillBean bean = new SecondKillBean(actNo);
        bean.setSecondKillConfigDTO(this.getCurSecondKillConfig(actNo));
        this.curConfigMap.put(actNo, bean);
        return bean;
    }

    public SecondKillConfigDTO getCurSecondKillConfig(String actNo) {
        List<SecondKillConfigDTO> configDTOList = this.secKillConfigsMap.get(actNo);
        if (CollectionUtils.isEmpty(configDTOList)) {
            return null;
        }
        if (configDTOList.size() == 1) {
            return configDTOList.get(0);
        }
        Date now = new Date();
        for (SecondKillConfigDTO configDTO : configDTOList) {
            Date configStartTime = null;
            Date configEndTime = null;
            try {
                configStartTime = DateUtil.parseByDefault(DateUtil.getCurDateStr() + " " + configDTO.getReleaseTime());
                configEndTime = DateUtil.getEndTime(configStartTime, "minute", configDTO.getSecondKillMinutes());
            }
            catch (ParseException e) {
                logger.error("configTime Parse Exception:", e);
                continue;
            }
            if (now.before(configStartTime)) {
                return configDTO;
            }
            if (!now.after(configStartTime) || !now.before(configEndTime) || this.curConfigMap.get(actNo) == null || !this.curConfigMap.get(actNo).getReleaseFlag().booleanValue()) continue;
            return configDTO;
        }
        return configDTOList.get(0);
    }

    private void loadConfig() {
        this.allSecKillConfigs = FacadeFactory.INSTANCE.getSecondKillConfigBo().getAllValidSecondKillConfigs();
        if (CollectionUtils.isEmpty(this.allSecKillConfigs)) {
            return;
        }
        for (SecondKillConfigDTO secondKillConfigDTO : this.allSecKillConfigs) {
            List<SecondKillConfigDTO> secondKillConfigList = null;
            secondKillConfigList = this.secKillConfigsMap.containsKey(secondKillConfigDTO.getActNo()) ? this.secKillConfigsMap.get(secondKillConfigDTO.getActNo()) : new ArrayList<SecondKillConfigDTO>();
            secondKillConfigList.add(secondKillConfigDTO);
            this.secKillConfigsMap.put(secondKillConfigDTO.getActNo(), secondKillConfigList);
        }
        for (Map.Entry entry : this.secKillConfigsMap.entrySet()) {
            List configDTOList = (List)entry.getValue();
            if (CollectionUtils.isEmpty(configDTOList)) continue;
            Collections.sort(configDTOList, new Comparator<SecondKillConfigDTO>(){

                @Override
                public int compare(SecondKillConfigDTO o, SecondKillConfigDTO o2) {
                    return o.getReleaseTime().compareTo(o2.getReleaseTime());
                }
            });
        }
    }

    private void startJobSchedule() {
        StdSchedulerFactory factory = new StdSchedulerFactory();
        try {
            Scheduler scheduler = factory.getScheduler();
            for (SecondKillConfigDTO configDTO : this.allSecKillConfigs) {
                JobDetail jobDetail = JobBuilder.newJob(SecondKillJob.class).build();
                jobDetail.getJobDataMap().put("actNo", configDTO.getActNo());
                String releaseTime = configDTO.getReleaseTime();
                Calendar calendar = Calendar.getInstance();
                try {
                    calendar.setTime(DateUtil.parseByDefault(DateUtil.getCurDateStr() + " " + releaseTime));
                }
                catch (ParseException e) {
                    logger.error("JobScheduleThread Date ParseException:", e);
                    continue;
                }
                int hour = calendar.get(11);
                int minute = calendar.get(12);
                int second = calendar.get(13);
                String cronTrigger = second + " " + minute + " " + hour + " * * ?";
                try {
                    CronTrigger trigger = TriggerBuilder.newTrigger().withSchedule(CronScheduleBuilder.cronSchedule(cronTrigger)).build();
                    scheduler.scheduleJob(jobDetail, trigger);
                }
                catch (SchedulerException e) {
                    logger.error("JobScheduleThread scheduleJob Exception:", e);
                }
            }
            scheduler.start();
        }
        catch (SchedulerException e) {
            logger.error("JobScheduleThread run Exception:", e);
        }
    }

    private class JobScheduleThread
    extends Thread {
        private List<SecondKillConfigDTO> allSecKillConfigs;
        private StdSchedulerFactory factory;
        private Scheduler scheduler;

        public JobScheduleThread(List<SecondKillConfigDTO> allSecKillConfigs) {
            this.allSecKillConfigs = allSecKillConfigs;
            this.factory = new StdSchedulerFactory();
        }

        @Override
        public void run() {
            try {
                this.scheduler = this.factory.getScheduler();
                for (SecondKillConfigDTO configDTO : this.allSecKillConfigs) {
                    JobDetail jobDetail = JobBuilder.newJob(SecondKillJob.class).build();
                    jobDetail.getJobDataMap().put("actNo", configDTO.getActNo());
                    String releaseTime = configDTO.getReleaseTime();
                    Calendar calendar = Calendar.getInstance();
                    try {
                        calendar.setTime(DateUtil.parseByDefault(DateUtil.getCurDateStr() + " " + releaseTime));
                    }
                    catch (ParseException e) {
                        logger.error("JobScheduleThread Date ParseException:", e);
                        continue;
                    }
                    int hour = calendar.get(11);
                    int minute = calendar.get(12);
                    int second = calendar.get(13);
                    String cronTrigger = second + " " + minute + " " + hour + " * * ?";
                    try {
                        CronTrigger trigger = TriggerBuilder.newTrigger().withSchedule(CronScheduleBuilder.cronSchedule(cronTrigger)).build();
                        this.scheduler.scheduleJob(jobDetail, trigger);
                    }
                    catch (SchedulerException e) {
                        logger.error("JobScheduleThread scheduleJob Exception:", e);
                    }
                }
                this.scheduler.start();
            }
            catch (SchedulerException e) {
                logger.error("JobScheduleThread run Exception:", e);
            }
        }
    }
}

