/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity.platformgame;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.ActivityUtil;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.active.vo.PlatformGameAct;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PlatformGameActVoteInfo
extends DefaultCmd {
    private static Logger logger = Log.getLogger(PlatformGameActVoteInfo.class);
    private static List<VoteInfo> rankList;
    private List<VoteInfo> rank;

    @CmdMapper(value={"/platformgame/getVoteInfo.do"})
    public Object getVoteInfo(XLHttpRequest request, XLHttpResponse response) {
        try {
            Page page = new Page();
            page.addOrder("display", OrderType.ESC);
            List<PlatformGameAct> list = FacadeFactory.INSTANCE.getPlatformGameActBo().find(new PlatformGameAct(), page);
            LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
            for (PlatformGameAct temp : list) {
                map.put(temp.getGameid(), temp.getVotenum());
            }
            List<VoteInfo> rlist = this.getRank();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("info", map);
            result.put("rank", rlist);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("\u5e73\u53f0\u6e38\u620f\u6295\u7968\u6d3b\u52a8\u83b7\u53d6\u7968\u6570\u4fe1\u606f\u5f02\u5e38", e);
            return this.error("\u7f51\u7edc\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    private void updateTask() {
        String hour = DateUtil.formatNow("HH");
        String beginTime = hour.compareTo("12") < 0 ? DateUtil.formatNow("yyyy-MM-dd") : DateUtil.format(DateUtil.tomorrow(), "yyyy-MM-dd");
        Date beginDate = null;
        try {
            beginDate = DateUtil.parseByDefault(beginTime + " 12:00:00");
        }
        catch (ParseException e) {
            logger.error("\u65f6\u95f4\u8f6c\u5316\u5f02\u5e38", e);
        }
        long period = 86400000L;
        final Timer timer = new Timer("updatePlatformGameActRank");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    rankList = PlatformGameActVoteInfo.this.getRank();
                    if (ActivityUtil.getActStatus(EnvPropertyUtil.loadProperty("niux", "platformGameActBo")) >= 2) {
                        timer.cancel();
                    }
                }
                catch (Exception e) {
                    logger.error("\u5b9a\u65f6\u66f4\u65b0\u5e73\u53f0\u6e38\u620f\u6295\u7968\u6d3b\u52a8\u6392\u884c\u4efb\u52a1\u5f02\u5e38", e);
                }
            }
        }, beginDate, period);
    }

    private String error(String errmsg) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("msg", errmsg);
        return JsonObjectUtil.getRtnAndDataJsonObject(1, error);
    }

    public List<VoteInfo> getRank() {
        Page page = new Page(1, 3);
        page.addOrder("votenum", OrderType.DESC);
        ArrayList<VoteInfo> list = new ArrayList<VoteInfo>();
        for (PlatformGameAct temp : FacadeFactory.INSTANCE.getPlatformGameActBo().find(new PlatformGameAct(), page)) {
            list.add(new VoteInfo(temp.getGameid(), temp.getVotenum()));
        }
        return list;
    }

    private static class VoteInfo {
        private String gameId;
        private int num;

        private VoteInfo() {
        }

        private VoteInfo(String gameId, int num) {
            this.gameId = gameId;
            this.num = num;
        }

        public String getGameId() {
            return this.gameId;
        }

        public void setGameId(String gameId) {
            this.gameId = gameId;
        }

        public int getNum() {
            return this.num;
        }

        public void setNum(int num) {
            this.num = num;
        }
    }
}

