/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity.platformgame;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.thirdclient.CardClient;
import com.xunlei.niux.center.util.ActivityUtil;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.center.util.Message;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.active.vo.PlatformGameGift;
import com.xunlei.niux.data.active.vo.PlatformGameVote;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PlatformGameActVoteCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(PlatformGameActVoteCmd.class);
    private final String sjGiftActNo = EnvPropertyUtil.loadProperty("niux", "platformGameActBo");
    private static final int DAY_MAX_VOTE_NUM = 5;
    private static final int DAY_MAX_IP_NUM = 10;
    private static Map<String, String> games = new HashMap<String, String>();

    @CmdMapper(value={"/platformgame/vote.do"})
    public Object vote(XLHttpRequest request, XLHttpResponse response) {
        int status = ActivityUtil.getActStatus(this.sjGiftActNo);
        if (status <= 0) {
            return this.error(Message.ACT_PREPARE);
        }
        if (status >= 2) {
            return this.error(Message.ACT_END);
        }
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            long userId = mainParam.getUserid();
            String userIp = request.getRemoteIP();
            String gameId = request.getParameter("gameId");
            if (StringUtil.isEmpty(gameId)) {
                return this.error("\u7f3a\u5c11\u53c2\u6570");
            }
            if (games.get(gameId) == null) {
                return this.error("\u53c2\u6570\u65e0\u6548");
            }
            if (this.counVoteByIp(userIp) >= 10) {
                return this.error("\u60a8\u8bbf\u95ee\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u660e\u5929\u518d\u6765\u6295\u7968\u5427!");
            }
            List<PlatformGameVote> voteList = this.findVoteByUserId(userId);
            int userVoteNum = voteList.size();
            if (userVoteNum >= 5) {
                return this.error("\u975e\u5e38\u62b1\u6b49\uff0c\u60a8\u4eca\u5929\u5df2\u7ecf\u6295\u8fc75\u6b21\u7968\uff0c\u8bf7\u660e\u5929\u518d\u6765\u3002");
            }
            if (this.hasVote(voteList, gameId)) {
                return this.error("\u975e\u5e38\u62b1\u6b49\uff0c\u6bcf\u6b3e\u6e38\u620f\u6bcf\u5929\u53ea\u80fd\u6295\u4e00\u6b21\u7968\uff0c\u5efa\u8bae\u60a8\u660e\u65e5\u518d\u4e3a\u5b83\u6295\u7968\u54e6\u3002");
            }
            if (this.isFirstVote(userId, gameId)) {
                this.logVote(gameId, userId, userIp);
                PlatformGameGift gift = this.initPlatformGameGift(userId, userIp, gameId);
                CardClient.CardClientResult result = this.getCode(gameId.substring(1, gameId.length()), userId, mainParam.getUserAccount(), games.get(gameId));
                if (result.getCode() == 0) {
                    gift.setStatus(true);
                    gift.setRemark(result.getMessage());
                    this.logGift(gift);
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("code", result.getResult());
                    return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
                }
                gift.setStatus(false);
                gift.setRemark(result.getMessage());
                this.logGift(gift);
                int leftvotenum = 5 - userVoteNum - 1;
                return this.error("\u606d\u559c\u60a8\uff0c\u5df2\u7ecf\u6295\u7968\u6210\u529f\uff0c\u5e76\u4e14\u83b7\u5f97\u4e00\u6b21\u62bd\u5956\u673a\u4f1a\uff0c\u60a8\u4eca\u5929\u8fd8\u5269" + leftvotenum + "\u6b21\u6295\u7968\u673a\u4f1a\u3002");
            }
            this.logVote(gameId, userId, userIp);
            int leftvotenum = 5 - userVoteNum - 1;
            return this.error("\u606d\u559c\u60a8\uff0c\u5df2\u7ecf\u6295\u7968\u6210\u529f\uff0c\u5e76\u4e14\u83b7\u5f97\u4e00\u6b21\u62bd\u5956\u673a\u4f1a\uff0c\u60a8\u4eca\u5929\u8fd8\u5269" + leftvotenum + "\u6b21\u6295\u7968\u673a\u4f1a\u3002");
        }
        catch (Exception e) {
            logger.error("\u5e73\u53f0\u6e38\u620f\u6d3b\u52a8\u6295\u7968\u5f02\u5e38", e);
            return this.error("\u7f51\u7edc\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    private PlatformGameGift initPlatformGameGift(long userId, String userIp, String gameId) {
        PlatformGameGift gift = new PlatformGameGift();
        gift.setUserid(userId);
        gift.setGameid(gameId);
        gift.setBatid(games.get(gameId));
        gift.setGifttime(new Date());
        gift.setUserip(userIp);
        return gift;
    }

    private void logGift(PlatformGameGift gift) {
        FacadeFactory.INSTANCE.getPlatformGameGiftBo().insert(gift);
    }

    private boolean isFirstVote(long userId, String gameId) {
        PlatformGameVote vote = new PlatformGameVote();
        vote.setUserid(userId);
        vote.setGameid(gameId);
        return FacadeFactory.INSTANCE.getPlatformGameVoteBo().count(vote) == 0;
    }

    private boolean hasVote(List<PlatformGameVote> voteList, String gameId) {
        boolean voteStatus = false;
        for (PlatformGameVote vote : voteList) {
            if (!gameId.equals(vote.getGameid())) continue;
            voteStatus = true;
            break;
        }
        return voteStatus;
    }

    private List<PlatformGameVote> findVoteByUserId(long userId) {
        PlatformGameVote vote = new PlatformGameVote();
        vote.setUserid(userId);
        vote.setFromVotetime(DateUtil.getTodayStartTime());
        return FacadeFactory.INSTANCE.getPlatformGameVoteBo().find(vote);
    }

    private void logVote(String gameId, long userId, String userIp) {
        this.logVoteInfo(gameId, userId, userIp);
        this.updatGameVoteNum(gameId);
    }

    private void logVoteInfo(String gameId, long userId, String userIp) {
        PlatformGameVote vote = new PlatformGameVote();
        vote.setGameid(gameId);
        vote.setUserip(userIp);
        vote.setUserid(userId);
        vote.setVotetime(new Date());
        FacadeFactory.INSTANCE.getPlatformGameVoteBo().insert(vote);
    }

    private void updatGameVoteNum(String gameId) {
        String sql = "update t_platformgame_info set votenum = votenum + 1 where gameid = ?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(gameId);
        FacadeFactory.INSTANCE.getPlatformGameActBo().execute(sql, params);
    }

    private int counVoteByIp(String userIp) {
        PlatformGameVote vote = new PlatformGameVote();
        vote.setUserip(userIp);
        vote.setFromVotetime(DateUtil.getTodayStartTime());
        return FacadeFactory.INSTANCE.getPlatformGameVoteBo().count(vote);
    }

    private String error(String errmsg) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("msg", errmsg);
        return JsonObjectUtil.getRtnAndDataJsonObject(1, error);
    }

    private CardClient.CardClientResult getCode(String gameId, long userid, String username, String batid) {
        return CardClient.getResult(gameId, "1", "gift", batid, userid, username, false);
    }

    static {
        games.put("000081", "81");
        games.put("000083", "66");
        games.put("000058", "61");
        games.put("000080", "55");
        games.put("000074", "62");
        games.put("000075", "58");
        games.put("000069", "57");
        games.put("000073", "54");
        games.put("000057", "53");
        games.put("000076", "59");
        games.put("000087", "70");
        games.put("000086", "63");
    }
}

