/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity.platformgame;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.activity.platformgame.PlatformGameActPrizeEnum;
import com.xunlei.niux.center.util.ActivityUtil;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.active.vo.PlatformGamePrize;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PlatformGameActPrizeListCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(PlatformGameActPrizeListCmd.class);
    private static List<GetPrizeInfo> prizeList;
    private List<GetPrizeInfo> prizeLists;

    @CmdMapper(value={"/platformgame/getPrizeList.do"})
    public Object getPrizeList(XLHttpRequest request, XLHttpResponse response) {
        try {
            if (prizeList == null) {
                prizeList = this.getPrizeLists();
                this.updateTask();
            }
            HashMap<String, List<GetPrizeInfo>> result = new HashMap<String, List<GetPrizeInfo>>();
            result.put("prizeList", prizeList);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            return this.error("\u7f51\u7edc\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    private void updateTask() {
        long period = 300000L;
        final Timer timer = new Timer("getPlatformGameActPrizeList");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    prizeList = PlatformGameActPrizeListCmd.this.getPrizeLists();
                    if (ActivityUtil.getActStatus(EnvPropertyUtil.loadProperty("niux", "platformGameActBo")) >= 2) {
                        timer.cancel();
                    }
                }
                catch (Exception e) {
                    logger.error("\u5b9a\u65f6\u66f4\u65b0\u5927\u5168\u62bd\u5956\u540d\u5355\u5f02\u5e38", e);
                }
            }
        }, period, period);
    }

    public List<GetPrizeInfo> getPrizeLists() {
        PlatformGamePrize platformGamePrize = new PlatformGamePrize();
        platformGamePrize.setPrizetype(PlatformGameActPrizeEnum.ONE.name());
        ArrayList<GetPrizeInfo> list = new ArrayList<GetPrizeInfo>();
        Page page = new Page(1, 10);
        page.addOrder("prizetime", OrderType.DESC);
        platformGamePrize = new PlatformGamePrize();
        platformGamePrize.setPrizetype(PlatformGameActPrizeEnum.VIP_HALF_YEAR.name());
        page.setPageSize(1);
        for (PlatformGamePrize temp : FacadeFactory.INSTANCE.getPlatformGamePrizeBo().find(platformGamePrize, page)) {
            list.add(new GetPrizeInfo(temp.getUsername(), temp.getPrizetype()));
        }
        platformGamePrize = new PlatformGamePrize();
        platformGamePrize.setPrizetype(PlatformGameActPrizeEnum.TWO.name());
        page.setPageSize(2);
        for (PlatformGamePrize temp : FacadeFactory.INSTANCE.getPlatformGamePrizeBo().find(platformGamePrize, page)) {
            list.add(new GetPrizeInfo(temp.getUsername(), temp.getPrizetype()));
        }
        platformGamePrize = new PlatformGamePrize();
        platformGamePrize.setPrizetype(PlatformGameActPrizeEnum.VIP_QUARTER_YEAR.name());
        page.setPageSize(1);
        for (PlatformGamePrize temp : FacadeFactory.INSTANCE.getPlatformGamePrizeBo().find(platformGamePrize, page)) {
            list.add(new GetPrizeInfo(temp.getUsername(), temp.getPrizetype()));
        }
        platformGamePrize = new PlatformGamePrize();
        platformGamePrize.setPrizetype(PlatformGameActPrizeEnum.VIP_MONTH.name());
        page.setPageSize(1);
        for (PlatformGamePrize temp : FacadeFactory.INSTANCE.getPlatformGamePrizeBo().find(platformGamePrize, page)) {
            list.add(new GetPrizeInfo(temp.getUsername(), temp.getPrizetype()));
        }
        int liftSize = 8 - list.size();
        if (liftSize > 0) {
            platformGamePrize = new PlatformGamePrize();
            platformGamePrize.setPrizetype(PlatformGameActPrizeEnum.ONE.name());
            page.setPageSize(liftSize);
            for (PlatformGamePrize temp : FacadeFactory.INSTANCE.getPlatformGamePrizeBo().find(platformGamePrize, page)) {
                list.add(new GetPrizeInfo(temp.getUsername(), temp.getPrizetype()));
            }
        }
        Collections.shuffle(list);
        return list;
    }

    private String error(String errmsg) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("msg", errmsg);
        return JsonObjectUtil.getRtnAndDataJsonObject(1, error);
    }

    private static class GetPrizeInfo {
        private String userName;
        private String prizeType;

        private GetPrizeInfo() {
        }

        private GetPrizeInfo(String userName, String prizeType) {
            this.prizeType = prizeType;
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPrizeType() {
            return this.prizeType;
        }

        public void setPrizeType(String prizeType) {
            this.prizeType = prizeType;
        }
    }
}

