/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity.platformgame;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.activity.platformgame.PlatformGameActPrizeEnum;
import com.xunlei.niux.center.util.ActivityConstant;
import com.xunlei.niux.center.util.ActivityUtil;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.center.util.Message;
import com.xunlei.niux.center.util.VipEnum;
import com.xunlei.niux.center.util.VipUtil;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.active.vo.PlatformGamePrize;
import com.xunlei.niux.data.active.vo.PlatformGameVote;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PlatformGameActPrizeCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(PlatformGameActPrizeCmd.class);
    private final String sjGiftActNo = EnvPropertyUtil.loadProperty("niux", "platformGameActBo");
    private static final int DAY_MAX_IP_NUM = 10;

    @CmdMapper(value={"/platformgame/getPrize.do"})
    public Object getPrize(XLHttpRequest request, XLHttpResponse response) {
        int status = ActivityUtil.getActStatus(this.sjGiftActNo);
        if (status <= 0) {
            return this.error(Message.ACT_PREPARE);
        }
        if (status >= 2) {
            return this.error(Message.ACT_END);
        }
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            long userId = mainParam.getUserid();
            String userIp = request.getRemoteIP();
            String userName = mainParam.getUserAccount();
            if (this.countPrizeByIp(userIp) >= 10) {
                return this.error("\u60a8\u8bbf\u95ee\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u660e\u5929\u518d\u6765\u6295\u7968\u5427!");
            }
            int voteTimes = this.countVoteTimes(userId);
            if (voteTimes == 0) {
                return this.error("\u60a8\u8fd8\u672a\u83b7\u5f97\u62bd\u5956\u673a\u4f1a\uff0c\u8bf7\u53c2\u4e0e\u6295\u7968\u518d\u6765\u54df\uff01");
            }
            if (voteTimes - this.countPrizeByUserIdy(userId) > 0) {
                PlatformGameActPrizeEnum prize;
                if (this.isFirstPrize(userId)) {
                    prize = PlatformGameActPrizeEnum.ONE;
                    PlatformGameActPrizeCmd.logPrize(userId, prize, userIp, userName);
                } else {
                    prize = PlatformGameActPrizeCmd.getPrize(userId, userIp, userName);
                }
                if (prize == PlatformGameActPrizeEnum.WELCOME) {
                    return this.error("\u8fd0\u6c14\u592a\u574f\u4e86\uff0c\u8fd9\u6b21\u60a8\u6ca1\u6709\u62bd\u4e2d\u5956\u52b1\u3002\u53ef\u4ee5\u7ee7\u7eed\u8bd5\u8bd5\u624b\u6c14\u3002");
                }
                VipUtil.sender(ActivityConstant.BIG_ACT_NO, userId, prize.getVipEnum());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("prizeType", prize.name());
                return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
            }
            return this.error("\u975e\u5e38\u62b1\u6b49\uff0c\u60a8\u7684\u62bd\u5956\u673a\u4f1a\u5df2\u7528\u5b8c\uff0c\u53c2\u4e0e\u6295\u7968\uff0c\u5373\u53ef\u83b7\u5f97\u62bd\u5956\u673a\u4f1a\uff1a\uff09");
        }
        catch (Exception e) {
            logger.error("\u5e73\u53f0\u6e38\u620f\u6295\u7968\u62bd\u5956\u5f02\u5e38", e);
            return this.error(Message.ERROR);
        }
    }

    private boolean isFirstPrize(long userId) {
        PlatformGamePrize platformGamePrize = new PlatformGamePrize();
        platformGamePrize.setUserid(userId);
        return FacadeFactory.INSTANCE.getPlatformGamePrizeBo().count(platformGamePrize) == 0;
    }

    private int countPrizeByIp(String userIp) {
        PlatformGamePrize platformGamePrize = new PlatformGamePrize();
        platformGamePrize.setUserip(userIp);
        platformGamePrize.setFromPrizeTime(DateUtil.getTodayStartTime());
        return PlatformGameActPrizeCmd.countPlatformGamePrize(platformGamePrize);
    }

    private int countVoteTimes(long userId) {
        PlatformGameVote vote = new PlatformGameVote();
        vote.setUserid(userId);
        vote.setFromVotetime(DateUtil.getTodayStartTime());
        return FacadeFactory.INSTANCE.getPlatformGameVoteBo().count(vote);
    }

    private int countPrizeByUserIdy(long userId) {
        PlatformGamePrize platformGamePrize = new PlatformGamePrize();
        platformGamePrize.setUserid(userId);
        platformGamePrize.setFromPrizeTime(DateUtil.getTodayStartTime());
        return PlatformGameActPrizeCmd.countPlatformGamePrize(platformGamePrize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PlatformGameActPrizeEnum getPrize(long userId, String userIp, String userName) {
        PlatformGameActPrizeEnum prize = PlatformGameActPrizeEnum.getPrize();
        if (prize.getDayLimitNum() > 0) {
            PlatformGameActPrizeEnum platformGameActPrizeEnum = prize;
            synchronized (platformGameActPrizeEnum) {
                if (PlatformGameActPrizeCmd.countPrizeByDay(prize) >= prize.getDayLimitNum()) {
                    prize = PlatformGameActPrizeEnum.WELCOME;
                } else if (prize.getHourLimitNum() > 0 && PlatformGameActPrizeCmd.countPrizeByHour(prize) >= prize.getHourLimitNum()) {
                    prize = PlatformGameActPrizeEnum.WELCOME;
                }
                PlatformGameActPrizeCmd.logPrize(userId, prize, userIp, userName);
            }
        } else {
            PlatformGameActPrizeCmd.logPrize(userId, prize, userIp, userName);
        }
        return prize;
    }

    private static int countPrizeByHour(PlatformGameActPrizeEnum prize) {
        String startHour = DateUtil.formatNow("yyyy-MM-dd HH") + ":00:00";
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, 1);
        String endHour = DateUtil.format(calendar.getTime(), "yyyy-MM-dd HH") + ":00:00";
        try {
            Date startTime = DateUtil.parseByDefault(startHour);
            Date endTime = DateUtil.parseByDefault(endHour);
            return PlatformGameActPrizeCmd.countPrizeByDate(prize, startTime, endTime);
        }
        catch (ParseException e) {
            throw new RuntimeException("This should never happen, I make sure this parse style is right", e);
        }
    }

    private static int countPrizeByDay(PlatformGameActPrizeEnum prize) {
        Date fromDate = DateUtil.getTodayStartTime();
        return PlatformGameActPrizeCmd.countPrizeByDate(prize, fromDate, null);
    }

    private static int countPrizeByDate(PlatformGameActPrizeEnum prize, Date fromDate, Date toDate) {
        PlatformGamePrize platformGamePrize = new PlatformGamePrize();
        platformGamePrize.setPrizetype(prize.name());
        platformGamePrize.setFromPrizeTime(fromDate);
        platformGamePrize.setToPrizeTime(toDate);
        return PlatformGameActPrizeCmd.countPlatformGamePrize(platformGamePrize);
    }

    private static int countPlatformGamePrize(PlatformGamePrize platformGamePrize) {
        return FacadeFactory.INSTANCE.getPlatformGamePrizeBo().count(platformGamePrize);
    }

    private static void logPrize(long userId, PlatformGameActPrizeEnum prize, String userIp, String userName) {
        PlatformGamePrize platformGamePrize = new PlatformGamePrize();
        platformGamePrize.setUserid(userId);
        platformGamePrize.setPrizetime(new Date());
        platformGamePrize.setUsername(userName);
        platformGamePrize.setPrizetype(prize.name());
        VipEnum vip = prize.getVipEnum();
        if (vip != null) {
            platformGamePrize.setPrizename(vip.getName());
        } else {
            platformGamePrize.setPrizename(prize.getName());
        }
        platformGamePrize.setUserip(userIp);
        FacadeFactory.INSTANCE.getPlatformGamePrizeBo().insert(platformGamePrize);
    }

    private String error(String errmsg) {
        return JsonObjectUtil.getRtnAndDataJsonObject(1, errmsg, null);
    }
}

