/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.thirdclient.CardClient;
import com.xunlei.niux.center.util.ActivityUtil;
import com.xunlei.niux.center.util.Message;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.active.vo.SjGift;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.http.VipProxy;
import com.xunlei.util.Log;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SjGiftCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(SjGiftCmd.class);
    private final String sjGiftActNo = EnvPropertyUtil.loadProperty("niux", "sjGiftActNo");

    @CmdMapper(value={"/activity/getSjGift.do"})
    public Object getPrize(XLHttpRequest request, XLHttpResponse response) {
        int status = ActivityUtil.getActStatus(this.sjGiftActNo);
        if (status <= 0) {
            return this.error(Message.ACT_PREPARE);
        }
        if (status >= 2) {
            return this.error(Message.ACT_END);
        }
        String giftType = request.getParameter("giftType");
        if (StringUtil.isEmpty(giftType)) {
            return this.error("\u7f3a\u5c11\u53c2\u6570");
        }
        try {
            GiftType gType = GiftType.valueOfType(Integer.valueOf(giftType));
            if (gType == null) {
                return this.error("\u7c7b\u578b\u9519\u8bef");
            }
            MainParam mainParam = this.getMainParam(request, response, true);
            long userid = mainParam.getUserid();
            boolean isVip = this.isVip(userid);
            if (gType == GiftType.VIP && !isVip) {
                return this.error(Message.getMessage("SJ_ACT_GIFT_LIMINT"));
            }
            if (this.countByIdAndType(userid, gType.type) <= 0) {
                CardClient.CardClientResult code = this.getCode(userid, mainParam.getUserAccount(), gType.getBatid());
                if (code != null) {
                    if (code.getCode() == 0) {
                        this.logInfo(userid, isVip, gType.getType());
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("code", code.getResult());
                        return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
                    }
                    if (code.getCode() == 2) {
                        return this.error(Message.getMessage("SJ_ACT_HAS_GIFT") + "\u6fc0\u6d3b\u7801\u4e3a\uff1a" + code.getResult());
                    }
                    if (code.getCode() == -99) {
                        return this.error(Message.getMessage("SJ_ACT_GIFT_NONE"));
                    }
                    if (code.getCode() == -2) {
                        return this.error("\u8bf7\u60a8\u5148\u5efa\u7acb\u6e38\u620f\u89d2\u8272\u540e\uff0c\u518d\u6765\u9886\u53d6\u793c\u5305\u3002");
                    }
                    return this.error(Message.ERROR);
                }
                return this.error(Message.ERROR);
            }
            CardClient.CardClientResult code = this.getCode(userid, mainParam.getUserAccount(), gType.getBatid());
            return this.error(Message.getMessage("SJ_ACT_HAS_GIFT") + "\u6fc0\u6d3b\u7801\u4e3a\uff1a" + code.getResult());
        }
        catch (Exception e) {
            logger.error("\u795e\u5c06\u4e09\u56fd\u6d3b\u52a8\u5f02\u5e38", e);
            return this.error(Message.ERROR);
        }
    }

    private boolean isVip(long userid) {
        VipProxy.VipState vipState = ProxyFactory.getInstance().getVipProxy().getVipState(userid);
        return vipState.isVip() && vipState.getPayid() < 1000;
    }

    private int countByIdAndType(long userid, int type) {
        SjGift sjGift = new SjGift();
        sjGift.setUserid(userid);
        sjGift.setGifttype(type);
        return FacadeFactory.INSTANCE.getSjGiftBo().count(sjGift);
    }

    private String error(String errmsg) {
        return JsonObjectUtil.getRtnAndDataJsonObject(1, errmsg, null);
    }

    private CardClient.CardClientResult getCode(long userid, String username, String batid) {
        return CardClient.getResult("00087", "1", "gift", batid, userid, username, false);
    }

    private void logInfo(long userid, boolean vip, int type) {
        SjGift sjGift = new SjGift();
        sjGift.setUserid(userid);
        sjGift.setGifttype(type);
        sjGift.setGifttime(new Date());
        sjGift.setVip(vip);
        FacadeFactory.INSTANCE.getSjGiftBo().insert(sjGift);
    }

    private static enum GiftType {
        ALL(1, "48"),
        VIP(2, "49");

        private int type;
        private String batid;

        private GiftType(int type, String batid) {
            this.type = type;
            this.batid = batid;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getBatid() {
            return this.batid;
        }

        public void setBatid(String batid) {
            this.batid = batid;
        }

        public static GiftType valueOfType(int type) {
            GiftType giftType = null;
            for (GiftType temp : GiftType.values()) {
                if (type != temp.getType()) continue;
                giftType = temp;
                break;
            }
            return giftType;
        }
    }
}

