/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.data.manager.facade.FacadeFactory;
import com.xunlei.niux.data.manager.vo.Activity;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GetActive
extends DefaultCmd {
    private static final Logger logger = Log.getLogger(GetActive.class.getName());
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final String picpathpre = EnvPropertyUtil.loadProperty("niux", "niuxstaticpicpath");

    @CmdMapper(value={"/getActive.do"})
    public Object getActiveList(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u67e5\u8be2\u6d3b\u52a8");
        try {
            String acttype = request.getParameter("acttype");
            int pageno = request.getParameterInteger("pageno");
            int pagesize = request.getParameterInteger("pagesize");
            Activity act = new Activity();
            String nowDate = sdf.format(new Date());
            act.setToshowBeginDate(nowDate);
            act.setFromshowEndDate(nowDate);
            if ("0".equals(acttype)) {
                act.setToactEndDate(nowDate);
            } else if ("1".equals(acttype)) {
                act.setToactBeginDate(nowDate);
                act.setFromactEndDate(nowDate);
            } else {
                act.setFromactBeginDate(nowDate);
            }
            PagedFliper fliper = new PagedFliper();
            fliper.setPageNo(pageno);
            fliper.setPageSize(pagesize);
            fliper.setSortColumn("displayorder desc");
            Sheet<Activity> sheet = FacadeFactory.INSTANCE.getActivityBo().queryActivities(act, fliper);
            int count = sheet.getRowcount();
            int totalpage = count / pagesize;
            if (count % pagesize > 0) {
                ++totalpage;
            }
            ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
            if (count > 0 && sheet.getDatas() != null && sheet.getDatas().size() > 0) {
                List list = (List)sheet.getDatas();
                for (Activity ka : list) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("link", ka.getLinkPath());
                    map.put("actname", ka.getActName());
                    map.put("actdesc", ka.getActDesc());
                    map.put("onlinetime", ka.getActBeginDate());
                    map.put("partiobj", ka.getParticipator());
                    map.put("actpic", picpathpre + ka.getPicPath());
                    data.add(map);
                }
            }
            RetData retData = new RetData();
            retData.setTotalpage(totalpage);
            retData.setData(data);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, retData);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6d3b\u52a8\u51fa\u73b0\u5f02\u5e38", e);
            RetData retData = new RetData();
            retData.setErrmsg(e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(1, retData);
        }
    }

    public static class RetData {
        private String errmsg = "";
        private int totalpage;
        private List<Map<String, String>> data = new ArrayList<Map<String, String>>();

        public String getErrmsg() {
            return this.errmsg;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public int getTotalpage() {
            return this.totalpage;
        }

        public void setTotalpage(int totalpage) {
            this.totalpage = totalpage;
        }

        public List<Map<String, String>> getData() {
            return this.data;
        }

        public void setData(List<Map<String, String>> data) {
            this.data = data;
        }
    }
}

