/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.FavoriteRecord;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class FavoriteRecordCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(FavoriteRecordCmd.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd mm:hh:ss");
    private static SimpleDateFormat sdfshort = new SimpleDateFormat("yyyy-MM-dd");
    private static String bizNo = EnvPropertyUtil.loadProperty("bonus", "favoritebizno");
    private static String bizPwd = EnvPropertyUtil.loadProperty("bonus", "favoritebizpwd");

    @CmdMapper(value={"/addFavorite.do"})
    public Object addFavorite(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.checkMainParam(request, response, true);
        if (mainParam == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", "99");
            map.put("msg", "session\u5931\u6548");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        String userId = String.valueOf(mainParam.getUserid());
        String userName = this.getUserName(request);
        String favoriteUrl = request.getParameter("favoriteUrl", "");
        String gameId = request.getParameter("gameId", "");
        try {
            if ("".equals(favoriteUrl) || "".equals(gameId)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("code", "13");
                map.put("msg", "\u65e0\u6548\u53c2\u6570");
                return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
            }
            FavoriteRecord fr = FacadeFactory.INSTANCE.getFavoriteRecordBo().findByUserId(userId);
            if (fr != null && fr.getIsGiveOut().booleanValue()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("code", "01");
                map.put("msg", "\u5df2\u6536\u85cf");
                map.put("bonusNum", fr.getBonusNum() + "");
                map.put("gameId", fr.getGameId());
                return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
            }
            Date now = new Date();
            String orderId = OrderNoUtil.getOrderNo();
            FavoriteRecord frecord = new FavoriteRecord();
            frecord.setBizNo("");
            frecord.setBonusNum(2);
            frecord.setFavoriteUrl(favoriteUrl);
            frecord.setFavoriteTime(sdf.format(now));
            frecord.setGameId(gameId);
            frecord.setIsGiveOut(false);
            frecord.setOrderId(orderId);
            frecord.setUserId(userId);
            frecord.setUserName(userName);
            FacadeFactory.INSTANCE.getFavoriteRecordBo().insert(frecord);
            boolean isSuccess = this.giveOutBonus(userId, userName, frecord.getBonusNum(), frecord.getOrderId(), sdfshort.format(now));
            if (!isSuccess) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("code", "02");
                map.put("msg", "\u79ef\u5206\u53d1\u653e\u5931\u8d25");
                return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
            }
            frecord = FacadeFactory.INSTANCE.getFavoriteRecordBo().findByOderId(frecord.getOrderId());
            frecord.setIsGiveOut(true);
            FacadeFactory.INSTANCE.getFavoriteRecordBo().update(frecord);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", "00");
            map.put("msg", "\u79ef\u5206\u53d1\u653e\u6210\u529f");
            map.put("gameId", frecord.getGameId());
            map.put("bonusNum", frecord.getBonusNum() + "");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            logger.error("\u7528\u6237id[" + userId + "]\u6536\u85cf\u7f51\u9875\u53d1\u751f\u5f02\u5e38", e);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", "99");
            map.put("msg", "\u672a\u77e5\u5f02\u5e38");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
    }

    private boolean giveOutBonus(String userId, String userName, Integer transNum, String transNo, String balanceDate) {
        try {
            BonusClient.recharge(userId, userName, transNum, transNo, balanceDate, bizNo, bizPwd, "\u6536\u85cf\u7f51\u9875");
            return true;
        }
        catch (Exception e) {
            logger.error("userId[" + userId + "]transNo[" + transNo + "]transNum[" + transNum + "]\u53d1\u653e\u79ef\u5206\u51fa\u73b0\u5f02\u5e38", e);
            return false;
        }
    }

    @CmdMapper(value={"/checkFavorited.do"})
    public Object checkFavorited(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.checkMainParam(request, response, true);
        if (mainParam == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", "99");
            map.put("msg", "session\u5931\u6548");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        String userId = String.valueOf(mainParam.getUserid());
        FavoriteRecord fr = FacadeFactory.INSTANCE.getFavoriteRecordBo().findByUserId(userId);
        if (fr == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", "00");
            map.put("msg", "\u6ca1\u6709\u6536\u85cf");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", "01");
        map.put("msg", "\u5df2\u6536\u85cf");
        map.put("gameId", fr.getGameId());
        map.put("bonusNum", fr.getBonusNum() + "");
        return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
    }

    private MainParam checkMainParam(XLHttpRequest request, XLHttpResponse response, boolean isSeccode) {
        try {
            return this.getMainParam(request, response, isSeccode);
        }
        catch (Exception e) {
            return null;
        }
    }
}

