/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.DESUtil;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.util.AuthorityUtil;
import com.xunlei.niux.data.vipgame.vo.activity.Coupon;
import com.xunlei.util.Log;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class CouponCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(CouponCmd.class);
    private static String importCouponKey = "polgfi0zyc";
    private static String entryCouponKey = "3pwdv42b6j";

    @CmdMapper(value={"/activity/addCoupon.do"})
    public Object addCoupon(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String oldSign = request.getParameter("sign", "");
        boolean isSuccess = this.isValidSign(request, importCouponKey, oldSign, new String[]{"couponType", "couponNo", "couponValue", "couponPwd"});
        if (!isSuccess) {
            return JsonObjectUtil.getRtnAndDataJsonObject(11, "\u7b7e\u540d\u9519\u8bef", null);
        }
        String couponType = request.getParameter("couponType", "");
        String couponNo = request.getParameter("couponNo", "");
        int couponValue = request.getParameterInteger("couponValue");
        String couponPwd = request.getParameter("couponPwd", "");
        String encryCouponNo = DESUtil.encryptDataNoNormal(couponNo, entryCouponKey);
        String encryCouponPwd = DESUtil.encryptDataNoNormal(couponPwd, entryCouponKey);
        try {
            Coupon coupon = new Coupon();
            coupon.setCouponNo(encryCouponNo);
            coupon.setCouponStatus(1);
            coupon.setCouponType(couponType);
            coupon.setCouponValue(couponValue);
            coupon.setCouponPwd(encryCouponPwd);
            FacadeFactory.INSTANCE.getBaseSo().addObject(coupon);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u6210\u529f", null);
        }
        catch (Exception e) {
            logger.error("addCoupon Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, e.toString(), null);
        }
    }

    @CmdMapper(value={"/activity/getUserCoupons.do"})
    public Object getUserCoupons(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        String actNo = request.getParameter("actno", "");
        List<Coupon> coupons = this.getDecryptCoupons(userId, actNo);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, coupons);
    }

    @CmdMapper(value={"/activity/getUserCouponsServer.do"})
    public Object getUserCouponsServer(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String userId = request.getParameter("userid", "");
        String actNo = request.getParameter("actno", "");
        String authId = request.getParameter("authid");
        String sign = request.getParameter("sign");
        String connectServerIp = request.getRemoteIP();
        if (StringUtils.isEmpty(userId) || StringUtils.isEmpty(actNo) || StringUtils.isEmpty(authId)) {
            String msg = "\u53c2\u6570\u4e3a\u7a7a\uff01";
            logger.error(msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, msg);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userid", userId);
        param.put("actno", actNo);
        param.put("authid", authId);
        Map<String, Object> authResult = AuthorityUtil.Authority(authId, sign, connectServerIp, param);
        int authCode = Integer.parseInt(authResult.get("code").toString());
        if (authCode != 0) {
            String msg = authResult.get("msg").toString();
            return JsonObjectUtil.getRtnAndDataJsonObject(authCode, msg);
        }
        List<Coupon> coupons = this.getDecryptCoupons(userId, actNo);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, coupons);
    }

    private List<Coupon> getDecryptCoupons(String userId, String actNo) {
        Coupon coupon = new Coupon();
        coupon.setUserId(userId);
        if (StringUtils.isNotEmpty(actNo)) {
            coupon.setUseActNo(actNo);
        }
        coupon.setCouponStatus(2);
        Page page = new Page();
        page.addOrder("useTime", OrderType.DESC);
        List<Coupon> coupons = FacadeFactory.INSTANCE.getBaseSo().findObjects(coupon, page);
        for (int i = 0; i < coupons.size(); ++i) {
            Coupon tempCoupon = coupons.get(i);
            tempCoupon.setCouponNo(DESUtil.decryptDataNoNormal(tempCoupon.getCouponNo(), entryCouponKey));
            tempCoupon.setCouponPwd(DESUtil.decryptDataNoNormal(tempCoupon.getCouponPwd(), entryCouponKey));
        }
        return coupons;
    }

    @CmdMapper(value={"/activity/giveOutCoupon.do"})
    public Object giveOutCoupon(XLHttpRequest request, XLHttpResponse response) {
        String orderId = null;
        String actNo = null;
        String userId = null;
        String couponType = null;
        int couponValue = 0;
        Coupon query = null;
        try {
            orderId = request.getParameter("orderId", "");
            actNo = request.getParameter("actNo", "");
            userId = request.getParameter("userId", "");
            couponType = request.getParameter("couponType", "");
            couponValue = request.getParameterInteger("couponValue");
            String oldSign = request.getParameter("sign", "");
            if (StringUtil.isEmpty(orderId, actNo, userId, couponType, String.valueOf(couponValue), oldSign)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(13, "\u53c2\u6570\u9519\u8bef\uff0c\u5b58\u5728null");
            }
            if (!this.isValidSign(request, importCouponKey, oldSign, new String[]{"orderId", "actNo", "userId", "couponType", "couponValue"})) {
                return JsonObjectUtil.getRtnAndDataJsonObject(11, "\u7b7e\u540d\u9519\u8bef");
            }
            query = new Coupon();
            query.setUseActNo(actNo);
            query.setUseOrderNo(orderId);
            query.setCouponStatus(2);
            Coupon oldcoupon = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (oldcoupon != null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u5df2\u9886\u53d6\u4f18\u60e0\u5238");
            }
            Coupon newcoupon = FacadeFactory.INSTANCE.getCouponBo().giveOutCoupon(couponType, couponValue, userId, actNo, orderId);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u6210\u529f", newcoupon);
        }
        catch (Exception e) {
            logger.error("giveOutCoupon Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, e.toString(), null);
        }
    }
}

