/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity;

import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.exception.NiuxException;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.center.thirdclient.CardClient;
import com.xunlei.niux.center.thirdclient.SmsClient;
import com.xunlei.niux.center.util.Validator;
import com.xunlei.niux.center.util.VerifyCodeUtil;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;
import com.xunlei.niux.data.vipgame.vo.MobileBindAct;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class BindMobileActCmd
extends DefaultCmd {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @CmdMapper(value={"/checkBindMobile.do"})
    public Object checkMobileBinded(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            MainParam mainParam = this.checkMainParam(request, response, true);
            String userId = String.valueOf(mainParam.getUserid());
            MobileBindAct mobileBindAct = FacadeFactory.INSTANCE.getMobileBindActBo().find(userId);
            if (mobileBindAct == null) {
                map.put("code", "00");
                map.put("msg", "\u53ef\u4ee5\u7ed1\u5b9a");
            } else {
                map.put("code", "1");
                map.put("serialNum", mobileBindAct.getSerialNum());
                map.put("msg", "\u60a8\u7684\u8d26\u53f7\u5df2\u7ecf\u6210\u529f\u7ed1\u5b9a\u8fc7\u624b\u673a\uff0c\u82e5\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d~");
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (NiuExceptionAndCode e) {
            map.put("code", e.code);
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            map.put("code", "99");
            map.put("msg", "\u672a\u77e5\u9519\u8bef");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
    }

    @CmdMapper(value={"/isBindMobile.do"})
    public Object isBindMobile(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            MainParam mainParam = this.checkMainParam(request, response, true);
            String userId = String.valueOf(mainParam.getUserid());
            CustomerInfo query = new CustomerInfo();
            query.setUid(userId);
            CustomerInfo customerInfo = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            boolean isBinded = false;
            if (customerInfo != null && customerInfo.getPhone() != null && !"".equals(customerInfo.getPhone())) {
                isBinded = true;
            }
            map.put("code", "00");
            map.put("isBind", isBinded);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (NiuExceptionAndCode e) {
            map.put("code", e.code);
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            map.put("code", "99");
            map.put("msg", "\u672a\u77e5\u9519\u8bef");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
    }

    @CmdMapper(value={"/checkBindMobileAndGift.do"})
    public Object checkMobileBindedAndGiveOutGift(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            MainParam mainParam = this.checkMainParam(request, response, true);
            String userId = String.valueOf(mainParam.getUserid());
            MobileBindAct mobileBindAct = FacadeFactory.INSTANCE.getMobileBindActBo().find(userId);
            if (mobileBindAct == null) {
                map.put("code", "00");
                map.put("msg", "\u672a\u7ed1\u5b9a");
                return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
            }
            map.put("code", "01");
            if (mobileBindAct.getSerialNum() == null || "".equals(mobileBindAct.getSerialNum())) {
                String gameId = request.getParameter("gameId", "");
                String serverId = request.getParameter("serverId", "");
                String batid = request.getParameter("batId", "");
                this.checkNotEmpty(gameId, "13", "\u6e38\u620f\u4e3a\u7a7a");
                this.checkNotEmpty(serverId, "13", "\u6e38\u620f\u5206\u533a\u4e3a\u7a7a");
                this.checkNotEmpty(batid, "13", "\u6279\u53f7\u4e3a\u7a7a");
                String tempGameId = gameId.length() > 5 ? gameId.substring(gameId.length() - 5) : gameId;
                String serialNum = CardClient.getCardCode22(tempGameId, serverId, "gift", batid, Long.valueOf(userId), this.getUserName(request), false);
                this.checkNotEmpty(serialNum, "99", "\u9886\u53d6\u5931\u8d25");
                mobileBindAct.setGameId(gameId);
                mobileBindAct.setGiftLot(batid);
                mobileBindAct.setSerialNum(serialNum);
                mobileBindAct.setServerId(serverId);
                FacadeFactory.INSTANCE.getMobileBindActBo().update(mobileBindAct);
            } else {
                map.put("code", "02");
            }
            map.put("serialNum", mobileBindAct.getSerialNum());
            map.put("msg", "\u60a8\u7684\u8d26\u53f7\u5df2\u7ecf\u6210\u529f\u7ed1\u5b9a\u8fc7\u624b\u673a\uff0c\u82e5\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d~");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (NiuExceptionAndCode e) {
            map.put("code", e.code);
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (NiuRuntimeException e) {
            map.put("code", e.code);
            String msg = e.getMessage() + "";
            msg = msg.contains("\u6682\u65e0\u65b0\u624b\u5361") ? "\u624b\u673a\u793c\u5305\u5df2\u7ecf\u9886\u53d6\u5b8c\u4e86~~\u8bf7\u53c2\u52a0\u5176\u4ed6\u6d3b\u52a8\u2026\u2026" : msg;
            map.put("msg", msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            map.put("code", "99");
            map.put("msg", "\u672a\u77e5\u9519\u8bef");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
    }

    @CmdMapper(value={"/sendIdentityCode.do"})
    public Object sendMobileIdentifyCode(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.checkMainParam(request, response, true);
            String mobile = request.getParameter("mobile", "");
            this.checkNotEmpty(mobile, "13", "\u624b\u673a\u53f7\u4e3a\u7a7a");
            if (Validator.isNotMobileNO(mobile)) {
                throw new NiuExceptionAndCode("13", "\u60a8\u8f93\u5165\u7684\u624b\u673a\u53f7\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            String verify = request.getParameter("verify");
            this.checkNotEmpty(verify, "13", "\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
            String verifyKey = request.getCookieValue("VERIFY_KEY");
            this.checkNotEmpty(verifyKey, "13", "\u9a8c\u8bc1\u7801\u5bc6\u94a5\u4e3a\u7a7a");
            if (!VerifyCodeUtil.isVerify(verifyKey, "MMA", verify)) {
                throw new NiuExceptionAndCode("13", "\u60a8\u7684\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165~");
            }
            SmsClient.sendIdentifyingCode(mobile, "\u611f\u8c22\u60a8\u53c2\u52a0\u8fc5\u96f7\u725bX\u9875\u6e38\u5e73\u53f0\u7684\u7ed1\u5b9a\u624b\u673a\u9886\u53d6\u793c\u5305\u6d3b\u52a8\uff0c\u60a8\u7684\u9a8c\u8bc1\u7801\u662f\uff1a{}");
            map.put("code", "00");
            map.put("msg", "\u6210\u529f");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (NiuExceptionAndCode e) {
            map.put("code", e.code);
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            map.put("code", "99");
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
    }

    @CmdMapper(value={"/checkMobileIdentiyCodeAndBind.do"})
    public Object checkMobileIdentifyCodeAndBind(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        MainParam mainParam = null;
        try {
            CustomerInfo customerInfo;
            mainParam = this.checkMainParam(request, response, true);
            String userId = String.valueOf(mainParam.getUserid());
            MobileBindAct mobileBindAct = FacadeFactory.INSTANCE.getMobileBindActBo().find(userId);
            if (mobileBindAct == null) {
                String mobile = request.getParameter("mobile", "");
                this.checkNotEmpty(mobile, "13", "\u624b\u673a\u53f7\u4e3a\u7a7a");
                if (Validator.isNotMobileNO(mobile)) {
                    throw new NiuExceptionAndCode("13", "\u60a8\u8f93\u5165\u7684\u624b\u673a\u53f7\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                }
                String identityCode = request.getParameter("identityCode", "");
                this.checkNotEmpty(identityCode, "13", "\u624b\u673a\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
                SmsClient.checkIdentifyingCode(mobile, identityCode);
                mobileBindAct = new MobileBindAct();
                mobileBindAct.setUserName(this.getUserName(request));
                mobileBindAct.setUserId(userId);
                mobileBindAct.setMobileNum(Long.valueOf(mobile));
                mobileBindAct.setBindTime(sdf.format(new Date()));
                FacadeFactory.INSTANCE.getMobileBindActBo().insert(mobileBindAct);
                mobileBindAct = FacadeFactory.INSTANCE.getMobileBindActBo().find(mobileBindAct.getUserId());
            }
            if ((customerInfo = this.getCustomerInfo(userId)) == null) {
                customerInfo = new CustomerInfo();
                customerInfo.setUid(userId);
                customerInfo.setPhone(mobileBindAct.getMobileNum() + "");
                customerInfo.setCheckPhone(true);
                customerInfo.setCheckFlag(false);
                FacadeFactory.INSTANCE.getCustomerInfoBo().insert(customerInfo);
            } else {
                customerInfo.setPhone(mobileBindAct.getMobileNum() + "");
                customerInfo.setCheckPhone(true);
                FacadeFactory.INSTANCE.getCustomerInfoBo().update(customerInfo);
            }
            if (mobileBindAct.getSerialNum() != null && !"".equals(mobileBindAct.getSerialNum())) {
                throw new NiuExceptionAndCode("1", "\u60a8\u7684\u8d26\u53f7\u5df2\u7ecf\u6210\u529f\u7ed1\u5b9a\u8fc7\u624b\u673a\uff0c\u5e76\u5df2\u7ecf\u9886\u53d6\u4e86\u6fc0\u6d3b\u7801\uff0c\u82e5\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d~");
            }
            String gameId = request.getParameter("gameId", "");
            String serverId = request.getParameter("serverId", "");
            String batid = request.getParameter("batId", "");
            this.checkNotEmpty(gameId, "13", "\u6e38\u620f\u4e3a\u7a7a");
            this.checkNotEmpty(serverId, "13", "\u6e38\u620f\u5206\u533a\u4e3a\u7a7a");
            this.checkNotEmpty(batid, "13", "\u6279\u53f7\u4e3a\u7a7a");
            String tempGameId = gameId.length() > 5 ? gameId.substring(gameId.length() - 5) : gameId;
            String serialNum = CardClient.getCardCode22(tempGameId, serverId, "gift", batid, Long.valueOf(userId), this.getUserName(request), false);
            this.checkNotEmpty(serialNum, "99", "\u9886\u53d6\u5931\u8d25");
            mobileBindAct.setGameId(gameId);
            mobileBindAct.setGiftLot(batid);
            mobileBindAct.setSerialNum(serialNum);
            mobileBindAct.setServerId(serverId);
            FacadeFactory.INSTANCE.getMobileBindActBo().update(mobileBindAct);
            map.put("code", "00");
            map.put("serialNum", serialNum);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (NiuExceptionAndCode e) {
            map.put("code", e.code);
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (NiuRuntimeException e) {
            map.put("code", e.code);
            String msg = e.getMessage() + "";
            msg = msg.contains("\u6682\u65e0\u65b0\u624b\u5361") ? "\u624b\u673a\u793c\u5305\u5df2\u7ecf\u9886\u53d6\u5b8c\u4e86~~\u8bf7\u53c2\u52a0\u5176\u4ed6\u6d3b\u52a8\u2026\u2026" : msg;
            map.put("msg", msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            map.put("code", "99");
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(1, map);
        }
    }

    public CustomerInfo getCustomerInfo(String uid) {
        CustomerInfo queryci = new CustomerInfo();
        queryci.setUid(uid);
        List<CustomerInfo> cilist = FacadeFactory.INSTANCE.getCustomerInfoBo().find(queryci, new Page());
        return cilist == null || cilist.size() == 0 ? null : cilist.get(0);
    }

    private MainParam checkMainParam(XLHttpRequest request, XLHttpResponse response, boolean isSeccode) throws NiuExceptionAndCode {
        MainParam mainParam = null;
        try {
            mainParam = this.getMainParam(request, response, isSeccode);
        }
        catch (Exception e) {
            throw new NiuExceptionAndCode("99", "\u767b\u5f55\u5931\u6548");
        }
        if (mainParam == null) {
            throw new NiuExceptionAndCode("99", "\u767b\u5f55\u5931\u6548");
        }
        return mainParam;
    }

    private void checkNotEmpty(String value, String errrorCode, String errorMsg) throws NiuExceptionAndCode {
        if (value == null || "".equals(value)) {
            throw new NiuExceptionAndCode(errrorCode, errorMsg);
        }
    }

    @CmdMapper(value={"/checkBindMobileAndJifen.do"})
    public Object checkBindMobileAndJifen(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.checkMainParam(request, response, true);
            String userId = String.valueOf(mainParam.getUserid());
            MobileBindAct mobileBindAct = FacadeFactory.INSTANCE.getMobileBindActBo().find(userId);
            if (mobileBindAct == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("hasReceiveJifen", 0);
                map.put("mobile", "");
                map.put("msg", "\u7ed1\u5b9a\u624b\u673a\u4e3a\u7a7a");
                return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
            }
            if (mobileBindAct.getBonusOrderNo() == null || "".equals(mobileBindAct.getBonusOrderNo())) {
                mobileBindAct.setBonusOrderNo(OrderNoUtil.getOrderNo() + "mb");
                mobileBindAct.setBonusNum(20);
                mobileBindAct.setBonusTime(sdf.format(new Date()));
                mobileBindAct.setGiveOutBonusSuccess(false);
                FacadeFactory.INSTANCE.getMobileBindActBo().update(mobileBindAct);
            }
            if (mobileBindAct.getGiveOutBonusSuccess() == null || !mobileBindAct.getGiveOutBonusSuccess().booleanValue()) {
                BonusClient.recharge(mobileBindAct.getUserId(), mobileBindAct.getUserName(), mobileBindAct.getBonusNum(), mobileBindAct.getBonusOrderNo(), mobileBindAct.getBonusTime().substring(0, 10), "bigbang");
                mobileBindAct.setGiveOutBonusSuccess(true);
                FacadeFactory.INSTANCE.getMobileBindActBo().update(mobileBindAct);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("hasReceiveJifen", 1);
            map.put("mobile", mobileBindAct.getMobileNum());
            map.put("msg", "\u9886\u53d6\u6210\u529f");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("hasReceiveJifen", 0);
            map.put("mobile", "");
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(1, map);
        }
    }

    @CmdMapper(value={"/getBindPhoneJifen.do"})
    public Object getBindPhoneJifen(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.checkMainParam(request, response, true);
            String userId = String.valueOf(mainParam.getUserid());
            MobileBindAct mobileBindAct = FacadeFactory.INSTANCE.getMobileBindActBo().find(userId);
            if (mobileBindAct == null) {
                Long mobile = this.checkMobileCode(request);
                mobileBindAct = new MobileBindAct();
                mobileBindAct.setUserId(userId);
                mobileBindAct.setUserName(this.getUserName(request));
                mobileBindAct.setMobileNum(mobile);
            }
            if (mobileBindAct.getBonusOrderNo() == null || "".equals(mobileBindAct.getBonusOrderNo())) {
                mobileBindAct.setBonusOrderNo(OrderNoUtil.getOrderNo() + "mb");
                mobileBindAct.setBonusNum(20);
                mobileBindAct.setBonusTime(sdf.format(new Date()));
                mobileBindAct.setGiveOutBonusSuccess(false);
            }
            if (mobileBindAct.getSeqId() == null || mobileBindAct.getSeqId() == 0L) {
                FacadeFactory.INSTANCE.getMobileBindActBo().insert(mobileBindAct);
                mobileBindAct = FacadeFactory.INSTANCE.getMobileBindActBo().find(mobileBindAct.getUserId());
            } else {
                FacadeFactory.INSTANCE.getMobileBindActBo().update(mobileBindAct);
            }
            CustomerInfo customerInfo = this.getCustomerInfo(userId);
            if (customerInfo == null) {
                customerInfo = new CustomerInfo();
                customerInfo.setUid(userId);
                customerInfo.setPhone(mobileBindAct.getMobileNum() + "");
                customerInfo.setCheckPhone(true);
                customerInfo.setCheckFlag(false);
                FacadeFactory.INSTANCE.getCustomerInfoBo().insert(customerInfo);
            } else {
                customerInfo.setPhone(mobileBindAct.getMobileNum() + "");
                customerInfo.setCheckPhone(true);
                FacadeFactory.INSTANCE.getCustomerInfoBo().update(customerInfo);
            }
            if (mobileBindAct.getGiveOutBonusSuccess() == null || !mobileBindAct.getGiveOutBonusSuccess().booleanValue()) {
                BonusClient.recharge(mobileBindAct.getUserId(), mobileBindAct.getUserName(), mobileBindAct.getBonusNum(), mobileBindAct.getBonusOrderNo(), mobileBindAct.getBonusTime().substring(0, 10), "bigbang");
                mobileBindAct.setGiveOutBonusSuccess(true);
                FacadeFactory.INSTANCE.getMobileBindActBo().update(mobileBindAct);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("receiveJifen", 1);
            map.put("msg", "\u9886\u53d6\u6210\u529f");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("receiveJifen", 0);
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(1, map);
        }
    }

    private Long checkMobileCode(XLHttpRequest request) throws NiuExceptionAndCode, NiuxException {
        String mobile = request.getParameter("mobile", "");
        this.checkNotEmpty(mobile, "13", "\u624b\u673a\u53f7\u4e3a\u7a7a");
        if (Validator.isNotMobileNO(mobile)) {
            throw new NiuExceptionAndCode("13", "\u60a8\u8f93\u5165\u7684\u624b\u673a\u53f7\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        String identityCode = request.getParameter("identityCode", "");
        this.checkNotEmpty(identityCode, "13", "\u624b\u673a\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        SmsClient.checkIdentifyingCode(mobile, identityCode);
        return Long.valueOf(mobile);
    }
}

