/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.activity;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.data.activity.dto.ActivityDTO;
import com.xunlei.niux.data.activity.facade.FacadeFactory;
import com.xunlei.niux.data.activity.vo.Activity;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ActivityCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(ActivityCmd.class);

    @CmdMapper(value={"/game/queryActivitys.do"})
    public Object queryActivitys(XLHttpRequest request, XLHttpResponse response) {
        try {
            ArrayList resultList = new ArrayList();
            this.setInnerContentType(request, response);
            String keyWord = request.getParameter("keyword");
            if (StringTools.isEmpty(keyWord)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List<Activity> actList = FacadeFactory.INSTANCE.getActivityBo().queryActivitys(keyWord, 4);
            for (Activity act : actList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", act.getTitle());
                map.put("number", act.getActno());
                resultList.add(map);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultList);
        }
        catch (Exception e) {
            logger.error("queryActivitys unknown Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef");
        }
    }

    @CmdMapper(value={"/game/queryActivitysByKeyWord.do"})
    public Object queryActivitysByKeyWord(XLHttpRequest request, XLHttpResponse response) {
        try {
            ArrayList resultList = new ArrayList();
            this.setInnerContentType(request, response);
            String keyWord = request.getParameter("keyword");
            if (StringTools.isEmpty(keyWord)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List<ActivityDTO> actList = FacadeFactory.INSTANCE.getActivityBo().queryActivitysByKeyWord(keyWord);
            for (ActivityDTO act : actList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("title", act.getTitle());
                map.put("link", act.getLink());
                map.put("photo", act.getPhoto());
                map.put("actno", act.getActno());
                resultList.add(map);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultList);
        }
        catch (Exception e) {
            logger.error("queryActivitys unknown Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef");
        }
    }

    @CmdMapper(value={"/activity/count.do"})
    public Object activityCount(XLHttpRequest request, XLHttpResponse response) {
        String gameIds = request.getParameter("gameIds");
        try {
            if (StringTools.isEmpty(gameIds)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            String[] ids = gameIds.split("_");
            HashMap result = new HashMap();
            for (String id : ids) {
                if (StringTools.isEmpty(id)) continue;
                String cacheData = this.getData(id);
                String[] datas = cacheData.split("_");
                if (StringTools.isEmpty(cacheData)) continue;
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("actNum", datas[0]);
                data.put("serverNum", datas[1]);
                result.put(id, data);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u53c2\u6570\u4e3a\u7a7a");
        }
    }

    private String getData(String gameId) {
        return "2_3";
    }
}

