/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameContent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GameContentCmd
extends DefaultCmd {
    private static final Logger logger = Logger.getLogger(GameContentCmd.class.getName());
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @CmdMapper(value={"/getGameContent.do"})
    public Object getGameContent(XLHttpRequest request, XLHttpResponse response) {
        long seqId = request.getParameterLong("seqId");
        int pageNo = request.getParameterInteger("pageNo");
        int pageSize = request.getParameterInteger("pageSize");
        try {
            String contentType = request.getParameter("contentType");
            if (contentType == null || "".equals(contentType)) {
                throw new RuntimeException("contentType is empty");
            }
            GameContent gameContent = new GameContent();
            gameContent.setAlreadyDelete(false);
            gameContent.setContentType(contentType);
            gameContent.setToPublishDate(sdf.format(new Date()));
            gameContent.setGameFK(seqId);
            RetData retData = new RetData();
            int count = FacadeFactory.INSTANCE.getGameContentBo().count(gameContent);
            if (count == 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(0, retData);
            }
            int totalPage = count / pageSize;
            if (count % pageSize > 0) {
                ++totalPage;
            }
            List<GameContent> list = FacadeFactory.INSTANCE.getGameContentBo().findGameContent(gameContent, pageNo, pageSize);
            ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
            for (GameContent gc : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("type", gc.getContentType());
                map.put("title", gc.getTitle());
                map.put("linkurl", gc.getJumpUrl());
                if (gc.getRed().booleanValue()) {
                    map.put("red", "1");
                } else {
                    map.put("red", "0");
                }
                if (gc.getBold().booleanValue()) {
                    map.put("bold", "1");
                } else {
                    map.put("bold", "0");
                }
                String publishDate = gc.getPublishDate();
                if (publishDate == null || publishDate.length() < 10) {
                    map.put("publishDate", publishDate);
                } else {
                    map.put("publishDate", publishDate.substring(0, 10));
                }
                data.add(map);
            }
            retData.setData(data);
            retData.setTotalpage(totalPage);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, retData);
        }
        catch (Exception e) {
            RetData retData = new RetData();
            retData.setErrmsg(e.getMessage());
            logger.error(e);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, retData);
        }
    }

    public static class RetData {
        private String errmsg = "";
        private int totalpage;
        private List<Map<String, String>> data = new ArrayList<Map<String, String>>();

        public String getErrmsg() {
            return this.errmsg;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public int getTotalpage() {
            return this.totalpage;
        }

        public void setTotalpage(int totalpage) {
            this.totalpage = totalpage;
        }

        public List<Map<String, String>> getData() {
            return this.data;
        }

        public void setData(List<Map<String, String>> data) {
            this.data = data;
        }
    }
}

