/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cache.GameFenQuCache;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.HttpClientUtil;
import com.xunlei.util.Log;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class CacheUpdate
extends DefaultCmd {
    private static Logger logger = Log.getLogger(CacheUpdate.class.getName());
    private static String copymachineips = ResourceBundle.getBundle("serverconfig").getString("copymachineips");
    private static String listen_port = ResourceBundle.getBundle("serverconfig").getString("listen_port");

    @CmdMapper(value={"/cacheupdate.do"})
    public Object update(XLHttpRequest request, XLHttpResponse response) {
        try {
            String notifyothers;
            int type = request.getParameterInteger("type");
            String gameId = request.getParameter("gameId");
            switch (type) {
                case 2: {
                    if (gameId == null || gameId.equals("")) break;
                    GameFenQuCache.getInstance().updateCacheByGameId(gameId);
                    break;
                }
                default: {
                    throw new Exception("type[" + type + "]\u4e0d\u5b58\u5728");
                }
            }
            if (!"0".equals(notifyothers = request.getParameter("notifyothers"))) {
                this.notifyOthersMachine(type);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, new RetData(""));
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, new RetData(e.getMessage()));
        }
    }

    private void notifyOthersMachine(int type) {
        if (copymachineips == null || "".equals(copymachineips)) {
            return;
        }
        String[] ips = copymachineips.split("\\|");
        for (int i = 0; i < ips.length; ++i) {
            String ip = ips[i];
            String res = HttpClientUtil.get("http://" + ip + ":" + listen_port, "/cacheupdate.do?type=" + type + "&notifyothers=0");
            if (res.contains("\"rtn\":0")) continue;
            logger.info("http://" + ip + ":" + listen_port + "/cacheupdate.do?type=" + type + "&notifyothers=0\u901a\u77e5\u5931\u8d25");
        }
    }

    public static class RetData {
        private String errmsg = "";

        public RetData(String errmsg) {
            this.errmsg = errmsg;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }
    }
}

