/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cache;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.center.util.FileUtil;
import com.xunlei.niux.center.util.JsonUtil;
import com.xunlei.niux.center.util.RBundleUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MyAreaMyGameCache {
    private static final Logger logger = Logger.getLogger(MyAreaMyGameCache.class.getName());
    private static MyAreaMyGameCache instance;
    private static Object lock;
    private static String gamedatafilepath;
    private List<Map<String, String>> myGameList;
    private String fileName = "myareamygame.js";

    private MyAreaMyGameCache() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MyAreaMyGameCache getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new MyAreaMyGameCache();
                }
            }
        }
        return instance;
    }

    public List<Map<String, String>> getMyGameList() {
        if (this.myGameList == null) {
            return new ArrayList<Map<String, String>>();
        }
        return this.myGameList;
    }

    public void updateCache() {
        ArrayList result = new ArrayList();
        LinkInfo info = new LinkInfo();
        info.setLinklocid("227");
        List<LinkInfo> gamelist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info);
        LinkInfo actinfo = new LinkInfo();
        info.setLinklocid("228");
        List<LinkInfo> actlist = FacadeFactory.INSTANCE.getLinkInfoBo().find(actinfo);
        LinkInfo photoinfo = new LinkInfo();
        info.setLinklocid("232");
        List<LinkInfo> photolist = FacadeFactory.INSTANCE.getLinkInfoBo().find(photoinfo);
        for (LinkInfo game : gamelist) {
            LinkedHashMap map = new LinkedHashMap();
            String gameid = game.getGameidbytuijian().trim();
            Games games = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(gameid);
            HashMap<String, String> data = new HashMap<String, String>();
            for (LinkInfo act : actlist) {
                if (!act.getGameidbytuijian().trim().equals(gameid)) continue;
                data.put("title", act.getLinktitle());
                data.put("url", act.getLinkurl());
                data.put("gameOfficialUrl", games.getOfficialWebSite());
            }
            for (LinkInfo photo : photolist) {
                if (!photo.getGameidbytuijian().trim().equals(gameid)) continue;
                data.put("photo", photo.getPicurl());
            }
            map.put(games.getGameNo(), data);
            result.add(map);
        }
        String json = JsonObjectUtil.getDataJsonObject(result);
        FileUtil.writeByChar(gamedatafilepath + this.fileName, json);
        this.myGameList.clear();
        instance = null;
    }

    private void init() {
        ArrayList<Map<String, String>> tmpQuestionTypeList = new ArrayList<Map<String, String>>();
        String json = FileUtil.readByChar(gamedatafilepath + this.fileName);
        if (json == null || "".equals(json)) {
            this.myGameList = tmpQuestionTypeList;
            return;
        }
        try {
            List list = (List)JsonUtil.jsonToObject(json);
            if (list == null) {
                this.myGameList = tmpQuestionTypeList;
                return;
            }
            for (Object obj : list) {
                Map map = (Map)obj;
                tmpQuestionTypeList.add(map);
            }
            this.myGameList = tmpQuestionTypeList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
    }

    static {
        lock = new Object();
        gamedatafilepath = RBundleUtil.getString("niux", "gamedatafilepath");
    }
}

