/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cache;

import java.util.HashSet;
import java.util.Set;

public class IpCacheManager {
    private static IpCacheManager instance;
    private static Object lock;
    private Set<String> ipCacheSet = null;
    private Long lastCreateTime = 0L;
    private Object addLock = new Object();

    private IpCacheManager() {
        this.createSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IpCacheManager getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new IpCacheManager();
                }
            }
        }
        return instance;
    }

    public boolean checkIpValid(String ip) {
        try {
            this.createSet();
            return !this.ipCacheSet.contains(ip);
        }
        catch (Exception e) {
            return true;
        }
    }

    public void addIp(String ip) {
        try {
            this.ipCacheSet.add(ip);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSet() {
        long now = System.currentTimeMillis();
        if (now - 360000L < this.lastCreateTime && this.ipCacheSet != null && this.ipCacheSet.size() < 5000) {
            return;
        }
        Object object = this.addLock;
        synchronized (object) {
            this.ipCacheSet = new HashSet<String>();
            this.lastCreateTime = now;
        }
    }

    static {
        lock = new Object();
    }
}

