/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cache;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.center.cache.QuestionTypeCache;
import com.xunlei.niux.center.util.FileUtil;
import com.xunlei.niux.center.util.JsonUtil;
import com.xunlei.niux.center.util.RBundleUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.QuestionGameCategory;
import com.xunlei.niux.data.vipgame.vo.QuestionSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GameSettingsCache {
    private static final Logger logger = Logger.getLogger(GameSettingsCache.class.getName());
    private static GameSettingsCache instance;
    private static Object lock;
    private static String gamedatafilepath;
    private List<Map<String, String>> gameSettingsList;
    private String fileName = "gamesettings.json";

    private GameSettingsCache() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GameSettingsCache getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new GameSettingsCache();
                }
            }
        }
        return instance;
    }

    public List<Map<String, String>> getGameSettingsCacheList() {
        if (this.gameSettingsList == null) {
            return new ArrayList<Map<String, String>>();
        }
        return this.gameSettingsList;
    }

    public void updateCache() {
        List<Map<String, String>> questiontypelist = QuestionTypeCache.getInstance().getQuestionTypeList();
        ArrayList paramList = new ArrayList();
        String sql = "select * from questionsettings";
        List settingsList = FacadeFactory.INSTANCE.getQuestionSettingsBo().findBySql(QuestionSettings.class, sql, paramList);
        sql = "select * from questiongamecategory";
        List gameCategoryList = FacadeFactory.INSTANCE.getQuestionGameCategoryBo().findBySql(QuestionGameCategory.class, sql, paramList);
        ArrayList gameList = new ArrayList(settingsList.size());
        boolean flag = false;
        ArrayList settings = new ArrayList();
        for (Object obj : settingsList) {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            QuestionSettings qs = (QuestionSettings)obj;
            String[] requiredids = qs.getRequireditemids().split(",");
            String[] requiredItems = qs.getRequireditems().split(";");
            ArrayList requiredList = new ArrayList();
            for (int i = 0; i < requiredids.length; ++i) {
                HashMap<String, Object> rmap = new HashMap<String, Object>();
                rmap.put("id", requiredids[i]);
                String name = requiredItems[i];
                if (name.indexOf(".") > -1) {
                    name = name.substring(name.indexOf(".") + 1);
                }
                rmap.put("reqname", name + "\uff1a");
                if (requiredItems[i].indexOf("\u622a\u56fe") != -1) {
                    rmap.put("isphoto", true);
                } else {
                    rmap.put("isphoto", false);
                }
                requiredList.add(rmap);
            }
            String optionalitemids = qs.getOptionalitemids();
            ArrayList optionalList = new ArrayList();
            if (optionalitemids != null && !"".equals(optionalitemids)) {
                String[] optionalids = optionalitemids.split(",");
                String[] optionalitems = qs.getOptionalitems().split(";");
                for (int i = 0; i < optionalids.length; ++i) {
                    HashMap<String, String> rmap = new HashMap<String, String>();
                    String name = optionalitems[i];
                    if (name.indexOf(".") > -1) {
                        name = name.substring(name.indexOf(".") + 1);
                    }
                    rmap.put("id", optionalids[i]);
                    rmap.put("optname", name + "\uff1a");
                    optionalList.add(rmap);
                }
            }
            map.put("gcid", qs.getGameid());
            map.put("qcid", qs.getQuestioncategoryid());
            map.put("requirelist", requiredList);
            map.put("optionallist", optionalList);
            settings.add(map);
        }
        String json = JsonObjectUtil.getDataJsonObject(gameList);
        FileUtil.writeByChar(gamedatafilepath + this.fileName, json);
        this.gameSettingsList.clear();
        instance = null;
    }

    private void addData(Long gameid, List requiredList, List optionalList, List gameCategoryList, List<Map<String, Object>> settings) {
        for (Object obj : gameCategoryList) {
            QuestionGameCategory qgc = (QuestionGameCategory)obj;
        }
    }

    private void init() {
        ArrayList<Map<String, String>> tmpGameCategoryList = new ArrayList<Map<String, String>>();
        String json = FileUtil.readByChar(gamedatafilepath + this.fileName);
        if (json == null || "".equals(json)) {
            this.gameSettingsList = tmpGameCategoryList;
            return;
        }
        try {
            List list = (List)JsonUtil.jsonToObject(json);
            if (list == null) {
                this.gameSettingsList = tmpGameCategoryList;
                return;
            }
            for (Object obj : list) {
                Map map = (Map)obj;
                tmpGameCategoryList.add(map);
            }
            this.gameSettingsList = tmpGameCategoryList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        lock = new Object();
        gamedatafilepath = RBundleUtil.getString("niux", "gamedatafilepath");
    }
}

