/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cache;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.center.util.FileUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class GameFenQuCache {
    private static Logger logger = Logger.getLogger(GameFenQuCache.class.getName());
    private static GameFenQuCache instance;
    private static Object lock;
    private static String gamedatafilepath;
    private static String rsyncgamedata;

    private GameFenQuCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GameFenQuCache getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new GameFenQuCache();
                }
            }
        }
        return instance;
    }

    public void updateCacheByGameId(String gameId) {
        if (gameId == null || "".equals(gameId)) {
            logger.info("gameId is empty");
            throw new RuntimeException("gameId is empty");
        }
        GameServers query = new GameServers();
        query.setGameId(gameId);
        List<GameServers> list = FacadeFactory.INSTANCE.getGameServersBo().findGameServers(query, 0, 0);
        ArrayList tlist = new ArrayList();
        for (GameServers gs : list) {
            if ("0".equals(gs.getOpenStatus()) || "2".equals(gs.getOpenStatus())) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("fenQuNum", String.valueOf(gs.getFenQuNum()));
            map.put("fenQuName", gs.getFenQuName());
            map.put("serverId", gs.getServerId());
            map.put("serverName", gs.getServerName());
            map.put("address", gs.getAddress());
            map.put("seqId", gs.getSeqId());
            map.put("openStatus", gs.getOpenStatus());
            map.put("fenQuNickName", gs.getFenQuNickName() == null || "".equals(gs.getFenQuNickName()) ? gs.getFenQuName() : gs.getFenQuNickName());
            map.put("bigFenQuName", gs.getBigFenQuName() == null ? "" : gs.getBigFenQuName());
            tlist.add(map);
        }
        String json = JsonObjectUtil.getDataJsonObject(tlist);
        FileUtil.writeByChar(gamedatafilepath + "fenqu/", gameId + ".json", "gamefenqus=" + json);
        try {
            Runtime.getRuntime().exec(rsyncgamedata);
        }
        catch (Exception e) {
            logger.error("\u51fa\u73b0\u5f02\u5e38", e);
            throw new RuntimeException(e);
        }
    }

    static {
        lock = new Object();
        gamedatafilepath = EnvPropertyUtil.loadProperty("niux", "gamedatafilepath");
        rsyncgamedata = EnvPropertyUtil.loadProperty("niux", "rsyncgamedata");
    }
}

