/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cache;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.center.util.FileUtil;
import com.xunlei.niux.center.util.JsonUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.QuestionGameCategory;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GameCategoryCache {
    private static final Logger logger = Logger.getLogger(GameCategoryCache.class.getName());
    private static GameCategoryCache instance;
    private static Object lock;
    private static String gamedatafilepath;
    private List<Map<String, String>> gameCategoryList;
    private String fileName = "gamecategory.json";

    private GameCategoryCache() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GameCategoryCache getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new GameCategoryCache();
                }
            }
        }
        return instance;
    }

    public List<Map<String, String>> getGameCategoryList() {
        if (this.gameCategoryList == null) {
            return new ArrayList<Map<String, String>>();
        }
        return this.gameCategoryList;
    }

    public void updateCache() {
        ArrayList paramList = new ArrayList();
        String sql = "select * from questiongamecategory";
        List gameCategoryList = FacadeFactory.INSTANCE.getQuestionGameCategoryBo().findBySql(QuestionGameCategory.class, sql, paramList);
        Page page = new Page();
        page.addOrder("simpleName", OrderType.ESC);
        List<Games> gameDatas = FacadeFactory.INSTANCE.getGamesBo().findGames(new Games(), page);
        ArrayList gameList = new ArrayList(gameDatas.size());
        boolean flag = false;
        for (Games game : gameDatas) {
            flag = false;
            HashMap<String, String> map = new HashMap<String, String>();
            for (Object obj : gameCategoryList) {
                QuestionGameCategory qgc = (QuestionGameCategory)obj;
                if (!qgc.getGameid().equals(game.getGameId())) continue;
                flag = true;
                map.put("gcid", qgc.getCategoryid() + "");
                break;
            }
            if (!flag) {
                map.put("gcid", "0");
            }
            map.put("gid", game.getGameId());
            map.put("gname", game.getGameName());
            gameList.add(map);
        }
        String json = JsonObjectUtil.getDataJsonObject(gameList);
        FileUtil.writeByChar(gamedatafilepath + this.fileName, json);
        gameCategoryList.clear();
        instance = null;
    }

    private void init() {
        ArrayList<Map<String, String>> tmpGameCategoryList = new ArrayList<Map<String, String>>();
        String json = FileUtil.readByChar(gamedatafilepath + this.fileName);
        if (json == null || "".equals(json)) {
            this.gameCategoryList = tmpGameCategoryList;
            return;
        }
        try {
            List list = (List)JsonUtil.jsonToObject(json);
            if (list == null) {
                this.gameCategoryList = tmpGameCategoryList;
                return;
            }
            for (Object obj : list) {
                Map map = (Map)obj;
                tmpGameCategoryList.add(map);
            }
            this.gameCategoryList = tmpGameCategoryList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        lock = new Object();
        gamedatafilepath = EnvPropertyUtil.loadProperty("niux", "gamedatafilepath");
    }
}

