/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cache;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GameCache {
    private static GameCache instance;
    private static Object instanceLock;
    private static long cacheTime;
    private long lastUpdateCacheTime = 0L;
    private Object updateCacheLock = new Object();
    private Map<String, Games> gameIdMap = new HashMap<String, Games>();

    private GameCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GameCache getInstance() {
        if (instance == null) {
            Object object = instanceLock;
            synchronized (object) {
                if (instance == null) {
                    instance = new GameCache();
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndupdateGameCache() {
        if (this.lastUpdateCacheTime + cacheTime < System.currentTimeMillis()) {
            Object object = this.updateCacheLock;
            synchronized (object) {
                if (this.lastUpdateCacheTime + cacheTime < System.currentTimeMillis()) {
                    this.updateGameCache();
                }
            }
        }
    }

    private void updateGameCache() {
        List<Games> gList = FacadeFactory.INSTANCE.getBaseSo().findObjects(new Games(), new Page());
        HashMap<String, Games> gMap = new HashMap<String, Games>();
        for (Games game : gList) {
            gMap.put(game.getGameId(), game);
        }
        this.gameIdMap = gMap;
        this.lastUpdateCacheTime = System.currentTimeMillis();
    }

    public Games getGameById(String gameId) {
        this.checkAndupdateGameCache();
        return this.gameIdMap.get(gameId);
    }

    static {
        instanceLock = new Object();
        cacheTime = 600000L;
    }
}

