/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.business.thread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.center.business.iface.ActivityBusiness;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Activity;
import com.xunlei.niux.data.vipgame.vo.tourist.TouristGameWebConfig;
import com.xunlei.util.Log;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class BusinessThread
implements Callable {
    private static Logger logger = Log.getLogger(BusinessThread.class);
    private Map<String, Object> paramMap;
    private BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();

    public BusinessThread(Map<String, Object> paramMap) {
        this.paramMap = paramMap;
    }

    public Map<String, Object> call() {
        return this.doActBusiness();
    }

    private Map<String, Object> doActBusiness() {
        String channelId = this.paramMap.get("channelId").toString();
        String gameId = this.paramMap.get("gameId").toString();
        Map mapResult = null;
        if (StringUtils.isEmpty(channelId) || StringUtils.isEmpty(gameId)) {
            return mapResult;
        }
        Activity activity = this.getDoBusinessClass(channelId, gameId);
        if (activity == null || StringUtils.isEmpty(activity.getDoBusinessClass())) {
            return mapResult;
        }
        String className = activity.getDoBusinessClass();
        if (StringUtils.isEmpty(className)) {
            return mapResult;
        }
        try {
            Class<?> clazz = Class.forName(className);
            this.paramMap.put("actNo", activity.getActno());
            ActivityBusiness activityBusiness = (ActivityBusiness)clazz.newInstance();
            Map<String, Object> result = activityBusiness.doBusiness(this.paramMap);
            if (MapUtils.isEmpty(result)) {
                logger.error("doBusiness result null!");
                return mapResult;
            }
            int code = Integer.parseInt(result.get("code").toString());
            if (code != 0) {
                logger.error("doBusiness result error:" + result.toString());
                return mapResult;
            }
            mapResult = (Map)result.get("data");
        }
        catch (Exception e) {
            logger.error(className + "execute error!", e);
            return mapResult;
        }
        return mapResult;
    }

    private Activity getDoBusinessClass(String channelId, String gameId) {
        Activity result = null;
        TouristGameWebConfig config = this.getTouristGameWebConfig(gameId, channelId);
        if (config == null) {
            return result;
        }
        if (StringUtils.isEmpty(config.getActNo())) {
            return result;
        }
        Activity activityQuery = new Activity();
        activityQuery.setActno(config.getActNo());
        Page page = new Page();
        page.addOrder("seqid", OrderType.DESC);
        List<Activity> activityList = this.baseSo.findObjects(activityQuery, page);
        if (CollectionUtils.isEmpty(activityList)) {
            return result;
        }
        result = activityList.get(0);
        return result;
    }

    private TouristGameWebConfig getTouristGameWebConfig(String gameId, String channelId) {
        TouristGameWebConfig result = null;
        TouristGameWebConfig query = new TouristGameWebConfig();
        query.setGameId(gameId);
        query.setIsValid(true);
        Page page = new Page();
        page.addOrder("seqid", OrderType.DESC);
        List<TouristGameWebConfig> touristGameWebConfigList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
        if (CollectionUtils.isEmpty(touristGameWebConfigList)) {
            return result;
        }
        HashMap<String, TouristGameWebConfig> configMap = new HashMap<String, TouristGameWebConfig>();
        for (TouristGameWebConfig config : touristGameWebConfigList) {
            if (configMap.containsKey(config.getChannelId())) continue;
            configMap.put(config.getChannelId(), config);
        }
        if (configMap.containsKey(channelId)) {
            result = (TouristGameWebConfig)configMap.get(channelId);
        } else if (configMap.containsKey("")) {
            result = (TouristGameWebConfig)configMap.get("");
        }
        return result;
    }
}

