/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.cache;

import com.xunlei.niux.cache.Cache;
import com.xunlei.niux.cache.SimpleMemCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CacheManager {
    private static final int MAXSIZE = 10000;
    private static Map<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
    private static CacheManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheManager GetInstance() {
        if (instance != null) return instance;
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (instance != null) return instance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return new CacheManager();
        }
    }

    private CacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        this.readLock.lock();
        try {
            if (cacheMap.containsKey(key)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        if (!this.containsKey(key)) {
            return null;
        }
        if (this.isExpired(key)) {
            this.remove(key);
            return null;
        }
        this.readLock.lock();
        try {
            Object object = cacheMap.get(key).getValue();
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object value, long expireTime) {
        if (this.isSizeFull()) {
            this.clear();
        }
        SimpleMemCache cache = new SimpleMemCache(key, value, System.currentTimeMillis() + 60000L * expireTime, false);
        this.writeLock.lock();
        try {
            cacheMap.put(key, cache);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void put(String key, Object value) {
        this.put(key, value, 120L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        this.writeLock.lock();
        try {
            cacheMap.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock.lock();
        try {
            cacheMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExpired(String key) {
        this.readLock.lock();
        try {
            Cache cache = cacheMap.get(key);
            if (System.currentTimeMillis() > cache.getTimeOut()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSizeFull() {
        this.readLock.lock();
        try {
            if (cacheMap.size() >= 1000) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String generateCacheKey(Class clazz, String key) {
        return clazz.getName() + "_" + key;
    }
}

