/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import com.xunlei.netty.httpserver.cmd.common.StatCmd;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.spring.AfterConfig;
import com.xunlei.util.DateStringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticsHelper {
    private boolean init;
    @Autowired
    private StatCmd statCmd;
    private static final int dayms = 86400000;
    private int snapshotDay = 30;
    private int snapshotMilliseconds = 600000;
    private int snapshotSize = 86400000 / this.snapshotMilliseconds * this.snapshotDay;
    private Snapshot[] snapshotArray = new Snapshot[this.snapshotSize];
    private int snapshotIndex = 0;
    private Snapshot maxTps;
    private long lastTps = 0L;

    @AfterConfig
    public synchronized void init() {
        if (this.init) {
            return;
        }
        Snapshot snapshot = new Snapshot(0L);
        this.snapshotArray[this.snapshotIndex++ % this.snapshotSize] = snapshot;
        this.maxTps = snapshot;
        HttpServerConfig.daemonTaskExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    Snapshot dss = new Snapshot(StatisticsHelper.this.statCmd.getProcessTSS().getAllNum());
                    Snapshot[] snapshotArray = StatisticsHelper.this.snapshotArray;
                    StatisticsHelper statisticsHelper = StatisticsHelper.this;
                    int n = statisticsHelper.snapshotIndex;
                    statisticsHelper.snapshotIndex = n + 1;
                    snapshotArray[n % ((StatisticsHelper)StatisticsHelper.this).snapshotSize] = dss;
                    Snapshot dss0 = StatisticsHelper.this.snapshotArray[StatisticsHelper.this.snapshotIndex - 2 % StatisticsHelper.this.snapshotSize];
                    StatisticsHelper.this.lastTps = StatisticsHelper.calcTps(dss, dss0);
                    if (StatisticsHelper.this.maxTps.getNum() <= StatisticsHelper.this.lastTps) {
                        StatisticsHelper.this.maxTps = new Snapshot(dss.getDate(), StatisticsHelper.this.lastTps);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, this.getSnapshotInitialDelay(), this.snapshotMilliseconds, TimeUnit.MILLISECONDS);
        this.init = true;
    }

    private long getSnapshotInitialDelay() {
        String truncateDateStr = String.valueOf(DateStringUtil.DEFAULT.now().substring(0, 15)) + "0:00";
        Date truncateDate = DateStringUtil.DEFAULT.parse(truncateDateStr);
        return truncateDate.getTime() + (long)this.snapshotMilliseconds - System.currentTimeMillis();
    }

    public List<Snapshot> getSnapshot(int sampleSize, long interval, boolean calcTps) {
        int size;
        int currentSnapshotIndex = this.snapshotIndex;
        int step = (int)(interval / (long)this.snapshotMilliseconds);
        if (step <= 0) {
            step = 1;
        }
        if ((size = sampleSize * step) > this.snapshotSize) {
            size = this.snapshotSize;
        }
        int beginIndex = currentSnapshotIndex - size;
        ArrayList<Snapshot> statList = new ArrayList<Snapshot>();
        if (calcTps) {
            if (beginIndex < step) {
                beginIndex = step;
            }
            int i = beginIndex;
            while (i < currentSnapshotIndex) {
                Snapshot dss0 = this.snapshotArray[(i - step) % this.snapshotSize];
                Snapshot dss = this.snapshotArray[i % this.snapshotSize];
                statList.add(new Snapshot(dss.getDate(), StatisticsHelper.calcTps(dss, dss0)));
                i += step;
            }
        } else {
            if (beginIndex < 0) {
                beginIndex = 0;
            }
            int i = beginIndex;
            while (i < currentSnapshotIndex) {
                Snapshot dss = this.snapshotArray[i % this.snapshotSize];
                statList.add(dss);
                i += step;
            }
        }
        return statList;
    }

    private static long calcTps(Snapshot dss, Snapshot dss0) {
        long num = dss.getNum() - dss0.getNum();
        long sec = (dss.getDate().getTime() - dss0.getDate().getTime()) / 1000L;
        if (sec <= 0L) {
            return 0L;
        }
        return num / sec;
    }

    public Snapshot getMaxTps() {
        return this.maxTps;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        int i = 0;
        while (i < this.snapshotIndex) {
            if (this.snapshotArray[i] == null) break;
            tmp.append(this.snapshotArray[i]).append("\n");
            ++i;
        }
        return tmp.toString();
    }

    public class Snapshot {
        private Date date;
        private long num;

        private Snapshot(long num) {
            this.date = new Date();
            this.num = num;
        }

        private Snapshot(Date date, long num) {
            this.date = date;
            this.num = num;
        }

        public Date getDate() {
            return this.date;
        }

        public long getNum() {
            return this.num;
        }

        public String toString() {
            return String.valueOf(DateStringUtil.DEFAULT.format(this.date)) + "   " + this.num;
        }
    }
}

