/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.handler;

import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.handler.Handler;
import com.xunlei.netty.httpserver.handler.TextResponseHandlerManager;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.spring.Config;
import com.xunlei.util.HttpUtil;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.util.Collections;
import java.util.Set;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class TextResponseHandler
implements Handler {
    public static final Logger log = Log.getLogger();
    @Autowired
    protected HttpServerConfig serverConfig;
    @Config
    protected String responseReturnNullInfo = "cmd return null";
    @Autowired
    protected TextResponseHandlerManager textResponseHandlerManager;
    private static final String launcherName;
    @Config(resetable=true, split=",")
    protected Set<String> logThrowableIgnoreList = Collections.emptySet();

    static {
        String command = System.getProperty("sun.java.command");
        launcherName = StringTools.isEmpty(command) ? HttpUtil.getLocalSampleIP() : String.valueOf(command.substring(command.lastIndexOf(46) + 1)) + "@" + HttpUtil.getLocalSampleIP();
    }

    public abstract String buildContentString(XLContextAttachment var1, Object var2);

    public abstract Object handleThrowable(XLContextAttachment var1, Throwable var2) throws Exception;

    public static void logError(final String mailTitleInfo, final String info, final Object ... args) {
        HttpServerConfig.daemonTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Object objEx = args[args.length - 1];
                String exInfo = "";
                if (objEx instanceof Throwable) {
                    exInfo = ((Throwable)objEx).getClass().getSimpleName();
                }
                String title = "[" + launcherName + "]" + exInfo + ": " + mailTitleInfo;
                MDC.put("mailTitle", title);
                log.error(info, args);
            }
        });
    }

    public void logThrowable(XLContextAttachment attach, XLHttpRequest request, XLHttpResponse response, Throwable ex) {
        response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        TextResponseHandler.logError(request.getUrl(), "\n{}", request.getDetailInfo(), ex);
    }
}

