/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.xunlei.netty.httpserver.cmd.CmdMappers;
import com.xunlei.netty.httpserver.component.AbstractPageDispatcher;
import com.xunlei.netty.httpserver.component.TimeoutInterrupter;
import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.netty.httpserver.util.NetUtil;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpPostRequestDecoder;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BasePageDispatcher
extends AbstractPageDispatcher {
    @Autowired
    protected CmdMappers cmdMappers;
    @Autowired
    protected HttpServerConfig config;
    @Autowired
    private TimeoutInterrupter timeoutInterrupter;

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
        this.config.getStatistics().channelClosed(ctx, e);
        XLContextAttachment attach = (XLContextAttachment)ctx.getAttachment();
        this.timeoutInterrupter.getAttachRegister().unregisterAttach(attach);
        XLHttpRequest request = attach.getRequest();
        if (request == null) {
            return;
        }
        HttpPostRequestDecoder decoder = request.getHttpPostRequestDecoder();
        if (decoder == null) {
            return;
        }
        decoder.cleanFiles();
    }

    @Override
    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.sendUpstream(e);
        this.config.getStatistics().channelOpen(ctx, e);
        XLContextAttachment attach = new XLContextAttachment(ctx);
        ctx.setAttachment(attach);
        this.timeoutInterrupter.getAttachRegister().registerAttach(attach);
    }

    protected abstract void dispatch(XLContextAttachment var1) throws Exception;

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        boolean channelInterrupt = NetUtil.exceptionCaught(ctx, e);
        if (channelInterrupt) {
            this.config.getStatistics().channelInterruptClosed(ctx);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        block7: {
            XLContextAttachment attach = (XLContextAttachment)ctx.getAttachment();
            Object obj = messageEvent.getMessage();
            try {
                if (obj instanceof XLHttpRequest) {
                    XLHttpRequest request = (XLHttpRequest)obj;
                    request.setRemoteAddress(messageEvent.getRemoteAddress());
                    request.setLocalAddress(messageEvent.getChannel().getLocalAddress());
                    attach.registerNewMessage(request);
                    if (!request.isChunked()) {
                        this.requestReceived(ctx, attach, request, messageEvent);
                    }
                    break block7;
                }
                if (obj instanceof HttpChunk) {
                    XLHttpRequest request = attach.getRequest();
                    HttpChunk httpChunk = (HttpChunk)obj;
                    request.offerChunk(httpChunk);
                    attach.markLastReadTime();
                    if (httpChunk.isLast()) {
                        this.requestReceived(ctx, attach, request, messageEvent);
                    }
                    break block7;
                }
                throw new RuntimeException("cant resolve message:" + obj);
            }
            finally {
                ctx.sendUpstream(messageEvent);
            }
        }
    }

    private void requestReceived(ChannelHandlerContext ctx, XLContextAttachment attach, XLHttpRequest request, MessageEvent messageEvent) throws Exception {
        XLHttpResponse response = new XLHttpResponse(attach);
        attach.registerNewMessage(response);
        this.config.getStatistics().messageReceived(attach);
        this.dispatch(attach);
    }

    @Override
    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        XLContextAttachment attach = (XLContextAttachment)ctx.getAttachment();
        this.config.getStatistics().writeComplete(attach, e);
        ctx.sendUpstream(e);
    }
}

