/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd.common;

import com.xunlei.netty.httpserver.Bootstrap;
import com.xunlei.netty.httpserver.cmd.BaseCmd;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.netty.httpserver.util.IPAuthenticator;
import com.xunlei.netty.httpserver.util.IPGetterHelper;
import com.xunlei.util.Log;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShutdownCmd
extends BaseCmd {
    private static final Logger log = Log.getLogger();
    @Autowired
    private Bootstrap bootstrap;

    @Override
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        final String ip = IPGetterHelper.getIP(request);
        log.error("{} try to shutdown", (Object)ip);
        IPAuthenticator.authLocalhost(request);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                log.error("{} SHUTDOWN HTTP SERVER....", (Object)ip);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long before = System.currentTimeMillis();
                try {
                    ShutdownCmd.this.bootstrap.stop();
                }
                finally {
                    long span = System.currentTimeMillis() - before;
                    String msg = "SHUTDOWN HTTP SERVER DONE...USING " + span + "MS";
                    System.err.println(msg);
                    HttpServerConfig.ALARMLOG.error("{}->{}", (Object)ip, (Object)msg);
                    System.exit(347);
                }
            }
        };
        Thread t = new Thread(run);
        t.start();
        return "GOOD BYE";
    }
}

