/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd.common;

import com.xunlei.command.CommandService;
import com.xunlei.netty.httpserver.cmd.BaseStatCmd;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.spring.AfterConfig;
import com.xunlei.spring.Config;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ShellCmd
extends BaseStatCmd {
    private static final Logger log = Log.getLogger();
    @Config(split="\\|\\|", resetable=true)
    private String[] shells = new String[0];
    private String[] shellsReal = new String[0];
    @Config(resetable=true)
    private String shellsDefaultCharset = "GBK";

    @AfterConfig
    public void init() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String selfPid = StringTools.splitAndTrim(name, "@").get(0);
        this.shellsReal = new String[this.shells.length];
        int i = 0;
        while (i < this.shells.length) {
            this.shellsReal[i] = this.shells[i].replaceAll("#SELF_PID#", selfPid);
            ++i;
        }
        if (this.shellsReal != null && this.shellsReal.length > 0) {
            log.warn("INIT SHELLS:\t\t{}", (Object)Arrays.toString(this.shellsReal));
        }
    }

    @Override
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        int index = request.getParameterInteger("exeIndex", -1);
        if (index == -1) {
            response.setInnerContentType(XLHttpResponse.ContentType.html);
            StringBuilder tmp = new StringBuilder();
            tmp.append("<html><body><table><tbody>\n");
            int i = 0;
            while (i < this.shellsReal.length) {
                String m = this.shellsReal[i];
                tmp.append(String.format("<tr><td><a target=\"_blank\" href=\"?exeIndex=%s\">%s</a></td></tr>\n", i, m));
                ++i;
            }
            tmp.append("</tbody></table></body></html>");
            return tmp.toString();
        }
        CommandService cs = new CommandService(this.shellsReal[index]);
        cs.execute(this.shellsDefaultCharset);
        return cs.getProcessingDetail();
    }
}

