/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd;

import com.xunlei.netty.httpserver.Bootstrap;
import com.xunlei.netty.httpserver.cmd.BaseCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.cmd.PathMap;
import com.xunlei.netty.httpserver.component.TimeoutInterrupter;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.spring.BeanUtil;
import com.xunlei.spring.Config;
import com.xunlei.util.EmptyChecker;
import com.xunlei.util.Log;
import com.xunlei.util.ReflectConvention;
import com.xunlei.util.ResourceBundleUtil;
import com.xunlei.util.ValueUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CmdMappers {
    @Autowired
    private TimeoutInterrupter timeoutInterrupter;
    public static final String defaultMethodName = BaseCmd.class.getDeclaredMethods()[0].getName();
    private static final String GLOBAL_TIMEOUT = "GLOBAL_TIMEOUT";
    private static final Logger log = Log.getLogger();
    private Map<String, CmdMeta> annotation_cmd_map = Collections.emptyMap();
    private Map<String, CmdMeta> auto_cmd_map = Collections.emptyMap();
    private Map<String, CmdMeta> auto_expand_cmd_map = Collections.emptyMap();
    private Map<String, CmdMeta> cmdAllMap = new LinkedHashMap<String, CmdMeta>();
    @Config
    private String cmdmapper_config_filename = "cmdmapper";
    private ResourceBundle cmdMapperBundle = null;
    private final Map<CmdMeta, CmdMeta> cmdMetaUnite = new HashMap<CmdMeta, CmdMeta>();
    private List<BaseCmd> cmds;
    @Autowired
    private HttpServerConfig config;
    private Map<String, CmdMeta> config_cmd_map = Collections.emptyMap();
    private Set<Class<? extends BaseCmd>> disableCmdClass = new HashSet<Class<? extends BaseCmd>>(0);
    private Set<Method> disableCmdMethod = new HashSet<Method>(0);
    private PathMap fuzzyMap;
    private int globalTimeout = Integer.MIN_VALUE;

    private static String sanitizePath(String path) {
        int len = path.length();
        if (len > 1 && path.lastIndexOf(47) == len - 1) {
            path = path.substring(0, len - 1);
        }
        return path;
    }

    private String _lower(String name) {
        return String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
    }

    private CmdMeta buildCmdMeta(String config) {
        String[] arg = config.split("\\.");
        if (arg.length >= 2) {
            BaseCmd cmd;
            String cmdMethodName;
            String cmdName;
            block8: {
                cmdName = this._lower(arg[0].trim());
                cmdMethodName = arg[1].trim();
                cmd = (BaseCmd)BeanUtil.getTypedBean(Bootstrap.CONTEXT, cmdName);
                if (cmd != null) break block8;
                return null;
            }
            try {
                Method method = cmd.getClass().getMethod(cmdMethodName, XLHttpRequest.class, XLHttpResponse.class);
                return this.newCmdMeta(cmd, method);
            }
            catch (Exception e) {
                log.error("cann't find cmd:{},method:{}", new Object[]{cmdName, cmdMethodName, e});
            }
        } else {
            BaseCmd cmd;
            String cmdName;
            block9: {
                cmdName = this._lower(config);
                cmd = (BaseCmd)BeanUtil.getTypedBean(Bootstrap.CONTEXT, cmdName);
                if (cmd != null) break block9;
                return null;
            }
            try {
                return this.newCmdMeta(cmd, null);
            }
            catch (Exception e) {
                log.error("cann't find cmd:{}", new Object[]{cmdName, e});
            }
        }
        return null;
    }

    private BaseCmd getCmd(String name) {
        Object obj = Bootstrap.CONTEXT.getBean(name);
        if (obj instanceof BaseCmd) {
            Class<?> clazz = obj.getClass();
            if (clazz.getAnnotation(Deprecated.class) != null || this.disableCmdClass.contains(clazz)) {
                return null;
            }
            return (BaseCmd)obj;
        }
        return null;
    }

    public Map<String, CmdMeta> getCmdAllSortedMap() {
        LinkedHashMap<String, CmdMeta> tmp = new LinkedHashMap<String, CmdMeta>();
        tmp.put("[ConfigMap\t" + this.config_cmd_map.size() + "]", null);
        tmp.putAll(this.config_cmd_map);
        tmp.put("\n[AnnotationMap\t" + this.annotation_cmd_map.size() + "]", null);
        tmp.putAll(this.annotation_cmd_map);
        tmp.put("\n[AutoMap\t" + this.auto_cmd_map.size() + "]", null);
        tmp.putAll(this.auto_cmd_map);
        tmp.put("\n[AutoExpandMap\t" + this.auto_expand_cmd_map.size() + "]", null);
        tmp.putAll(this.auto_expand_cmd_map);
        return tmp;
    }

    public ResourceBundle getCmdMapperBundle() {
        if (this.cmdMapperBundle == null) {
            this.cmdMapperBundle = ResourceBundleUtil.reload(this.cmdmapper_config_filename);
            if (this.cmdMapperBundle == null) {
                this.cmdMapperBundle = new ResourceBundle(){

                    @Override
                    public Enumeration<String> getKeys() {
                        return new Enumeration<String>(){

                            @Override
                            public boolean hasMoreElements() {
                                return false;
                            }

                            @Override
                            public String nextElement() {
                                return null;
                            }
                        };
                    }

                    @Override
                    protected Object handleGetObject(String key) {
                        return null;
                    }
                };
            }
        }
        return this.cmdMapperBundle;
    }

    public CmdMeta getCmdMeta(String path) throws Exception {
        CmdMeta meta = this.cmdAllMap.get(path = CmdMappers.sanitizePath(path));
        if (meta == null && this.fuzzyMap != null) {
            return (CmdMeta)this.fuzzyMap.match(path);
        }
        return meta;
    }

    private String getCmdName(BaseCmd cmd) {
        String cmdSuffix = this.config.getCmdSuffix();
        String cmdName = this._lower(cmd.getClass().getSimpleName());
        int idx = cmdName.indexOf(36);
        if (idx > 0) {
            cmdName = cmdName.substring(0, idx);
        }
        if (cmdName.endsWith(cmdSuffix)) {
            cmdName = cmdName.substring(0, cmdName.length() - cmdSuffix.length());
        }
        return cmdName;
    }

    private List<BaseCmd> getCmds() {
        if (this.cmds == null) {
            this.cmds = new ArrayList<BaseCmd>();
            String[] stringArray = Bootstrap.CONTEXT.getBeanDefinitionNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                BaseCmd cmd = this.getCmd(name);
                if (cmd != null) {
                    this.cmds.add(cmd);
                }
                ++n2;
            }
        }
        return this.cmds;
    }

    public int getGlobalToleranceTimeout() {
        if (this.globalTimeout == Integer.MIN_VALUE) {
            int noTimeout = 0;
            try {
                String v = this.getCmdMapperBundle().getString(GLOBAL_TIMEOUT);
                this.globalTimeout = ValueUtil.getInteger(v, noTimeout);
            }
            catch (Exception e) {
                this.globalTimeout = noTimeout;
            }
        }
        return this.globalTimeout;
    }

    public Map<String, CmdMeta> initAnnotationMap() {
        int n;
        LinkedHashMap<String, CmdMeta> tmp = new LinkedHashMap<String, CmdMeta>();
        boolean cmdMiscMethodExtenable = this.config.isCmdMiscMethodExtenable();
        for (BaseCmd cmd : this.getCmds()) {
            Class<?> clazz = cmd.getClass();
            CmdMapper m = clazz.getAnnotation(CmdMapper.class);
            if (m == null) continue;
            String[] stringArray = m.value();
            int n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String url = stringArray[n];
                this.putUrl(tmp, url, this.newCmdMeta(cmd, null));
                ++n;
            }
        }
        for (CmdMeta meta : this.cmdMetaUnite.values()) {
            CmdMapper m = meta.getMethod().getAnnotation(CmdMapper.class);
            if (m == null) continue;
            String[] stringArray = m.value();
            n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String url = stringArray[n3];
                this.putUrl(tmp, url, meta);
                ++n3;
            }
        }
        this.annotation_cmd_map = tmp;
        log.error("ANNOTATION_MAP:\t\t{}", this.annotation_cmd_map);
        this.cmdAllMap.putAll(tmp);
        return tmp;
    }

    public Map<String, CmdMeta> initAutoMap() {
        LinkedHashMap<String, CmdMeta> tmp_auto = new LinkedHashMap<String, CmdMeta>();
        LinkedHashMap<String, CmdMeta> tmp_expand = new LinkedHashMap<String, CmdMeta>();
        boolean cmdMiscMethodExtenable = this.config.isCmdMiscMethodExtenable();
        String cmdSuffix = this.config.getCmdSuffix();
        boolean cmdDefaultMethodVisiable = this.config.isCmdDefaultMethodVisiable();
        String cmdDefaultMethod = this.config.getCmdDefaultMethod();
        for (BaseCmd cmd : this.getCmds()) {
            Method[] mehods;
            String cmdName = this.getCmdName(cmd);
            Class<?> clazz = cmd.getClass();
            Method[] methodArray = mehods = cmdMiscMethodExtenable ? clazz.getMethods() : clazz.getDeclaredMethods();
            int n = mehods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (this.isCmdMethod(cmd, method)) {
                    CmdMeta meta = null;
                    String methodName = method.getName();
                    String methodUrl = MessageFormat.format("/{0}/{1}", cmdName, methodName);
                    if (method.getDeclaringClass().equals(cmd.getClass())) {
                        if (methodName.equals(cmdDefaultMethod)) {
                            meta = this.newCmdMeta(cmd, null);
                            tmp_auto.put("/" + cmdName, meta);
                            if (cmdDefaultMethodVisiable) {
                                tmp_expand.put(methodUrl, meta);
                            }
                        } else {
                            meta = this.newCmdMeta(cmd, method);
                            tmp_auto.put(methodUrl, meta);
                        }
                    } else if (cmdMiscMethodExtenable) {
                        if (methodName.equals(cmdDefaultMethod)) {
                            meta = this.newCmdMeta(cmd, null);
                            tmp_expand.put("/" + cmdName, meta);
                            if (cmdDefaultMethodVisiable) {
                                tmp_expand.put(methodUrl, meta);
                            }
                        } else {
                            meta = this.newCmdMeta(cmd, method);
                            tmp_expand.put(methodUrl, meta);
                        }
                    }
                }
                ++n2;
            }
        }
        this.auto_cmd_map = tmp_auto;
        this.auto_expand_cmd_map = tmp_expand;
        log.error("AUTO_MAP:\t\t{}", this.auto_cmd_map);
        log.error("AUTO_EXPAND_MAP:\t{}", this.auto_expand_cmd_map);
        this.cmdAllMap.putAll(tmp_auto);
        this.cmdAllMap.putAll(tmp_expand);
        LinkedHashMap<String, CmdMeta> tmp = new LinkedHashMap<String, CmdMeta>(tmp_auto.size() + tmp_expand.size());
        tmp.putAll(tmp_auto);
        tmp.putAll(tmp_expand);
        return tmp;
    }

    public Map<String, CmdMeta> initConfigMap() {
        ResourceBundle bundle = this.getCmdMapperBundle();
        LinkedHashMap<String, CmdMeta> tmp = new LinkedHashMap<String, CmdMeta>();
        if (bundle != null) {
            for (String url : bundle.keySet()) {
                String value;
                CmdMeta cm;
                if (!this.isUrlConfig(url) || (cm = this.buildCmdMeta(value = bundle.getString(url).trim())) == null) continue;
                this.putUrl(tmp, url, cm);
            }
        }
        this.config_cmd_map = tmp;
        log.error("CONFIG_MAP:\t\t{}", this.config_cmd_map);
        this.cmdAllMap.putAll(tmp);
        return tmp;
    }

    private boolean isCmdMethod(BaseCmd cmd, Method method) {
        if (method.getAnnotation(Deprecated.class) != null || this.disableCmdMethod.contains(method)) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        Class<?>[] pts = method.getParameterTypes();
        if (pts.length != 2) {
            return false;
        }
        return pts[0].isAssignableFrom(XLHttpRequest.class) && pts[1].isAssignableFrom(XLHttpResponse.class);
    }

    private boolean isUrlConfig(String cmdMapperBundleKey) {
        return cmdMapperBundleKey.startsWith("*") || cmdMapperBundleKey.startsWith("/");
    }

    private CmdMeta newCmdMeta(BaseCmd cmd, Method method) {
        CmdMeta tmp = new CmdMeta(cmd, method);
        CmdMeta ori = this.cmdMetaUnite.get(tmp);
        if (ori == null) {
            this.cmdMetaUnite.put(tmp, tmp);
            return tmp;
        }
        return ori;
    }

    public void printFuzzyMap() {
        if (this.fuzzyMap != null) {
            log.error("FUZZY_MAP:\t\t{}", this.fuzzyMap);
        }
    }

    private void putUrl(Map<String, CmdMeta> tmp, String url, CmdMeta meta) {
        if (url == null) {
            return;
        }
        if ((url = url.trim()).isEmpty()) {
            return;
        }
        if (url.contains("*")) {
            if (this.fuzzyMap == null) {
                this.fuzzyMap = new PathMap();
            }
            this.fuzzyMap.put(url, meta);
            return;
        }
        url = CmdMappers.sanitizePath(url);
        tmp.put(url, meta);
    }

    public void resetAllCounter() {
        for (CmdMeta meta : this.cmdMetaUnite.keySet()) {
            meta.resetCounter();
        }
    }

    public StringBuilder resetCmdConfig() {
        String msg;
        this.cmdMapperBundle = null;
        this.globalTimeout = Integer.MIN_VALUE;
        boolean damonScannerEnable = false;
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        for (CmdMeta meta : this.cmdMetaUnite.keySet()) {
            if (meta.isDisable()) {
                sb.append(meta.name).append(", ");
                continue;
            }
            if (meta.getTimeout() <= 0) continue;
            damonScannerEnable = true;
            sb1.append(meta.name).append("=").append(meta.getTimeout()).append(", ");
        }
        StringBuilder r = new StringBuilder();
        if (EmptyChecker.isNotEmpty(sb)) {
            msg = sb.substring(0, sb.length() - 2);
            log.error("DISABLE_SET:\t\t{{}}", (Object)msg);
            r.append("DISABLE_SET:\t\t{").append(msg).append("}\n");
        }
        if (EmptyChecker.isNotEmpty(sb1)) {
            msg = sb1.substring(0, sb1.length() - 2);
            log.error("TIMEOUT_SET:\t\t{{}}", (Object)msg);
            r.append("TIMEOUT_SET:\t\t{").append(msg).append("}\n");
        }
        this.timeoutInterrupter.setThreadInterrupterEnable(damonScannerEnable);
        boolean enable = this.timeoutInterrupter.isEnable();
        r.append(enable ? "TimeoutInterrupter Enable" : "TimeoutInterrupter Disable");
        return r;
    }

    public static class CmdMeta {
        private BaseCmd cmd;
        private Method method;
        private String name;
        protected AtomicLong num = new AtomicLong();
        private int timeout;

        private CmdMeta(BaseCmd cmd, Method method) {
            this.cmd = cmd;
            if (method == null) {
                try {
                    this.method = ReflectConvention.getDeclaredMethod(cmd.getClass(), defaultMethodName, XLHttpRequest.class, XLHttpResponse.class);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.name = cmd.getClass().getSimpleName();
            } else {
                this.method = method;
                this.name = String.valueOf(cmd.getClass().getSimpleName()) + "." + method.getName();
            }
        }

        public void access() {
            this.num.incrementAndGet();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CmdMeta other = (CmdMeta)obj;
            if (this.cmd == null ? other.cmd != null : !this.cmd.equals(other.cmd)) {
                return false;
            }
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }

        public BaseCmd getCmd() {
            return this.cmd;
        }

        public Method getMethod() {
            return this.method;
        }

        public long getNum() {
            return this.num.get();
        }

        public int getTimeout() {
            return this.timeout;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cmd == null ? 0 : this.cmd.hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        public boolean isDisable() {
            return this.timeout < 0;
        }

        public void resetCounter() {
            this.num = new AtomicLong();
        }

        public String toString() {
            return this.name;
        }
    }
}

