/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.async;

import com.xunlei.netty.httpserver.async.AsyncProxyOneAddrHandler;
import com.xunlei.util.Log;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;

public class AsyncProxyOneAddrPooledHandler
extends AsyncProxyOneAddrHandler {
    private static final Logger log = Log.getLogger();
    private final ConcurrentLinkedQueue<Channel> channelPool = new ConcurrentLinkedQueue();

    public AsyncProxyOneAddrPooledHandler(ClientBootstrap backstageClientBootstrap, String backstageHost, int backstagePort) {
        super(backstageClientBootstrap, backstageHost, backstagePort);
    }

    @Override
    protected void messageReceivedFinally(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.channelPool.offer(ctx.getChannel());
    }

    @Override
    protected Channel getChannel() {
        Channel c = this.channelPool.poll();
        if (c == null) {
            log.debug("channelPoll hasn't any available channel,creat one!");
            return this.newChannel();
        }
        if (!c.isConnected()) {
            log.debug("channelPoll has one unavailable channel:{},creat another!", c);
            this.channelAttachMap.remove(c);
            return this.newChannel();
        }
        log.debug("channelPoll has one available channel:{}", c);
        return c;
    }

    public ConcurrentLinkedQueue<Channel> getChannelPool() {
        return this.channelPool;
    }
}

