/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver;

import com.xunlei.netty.httpserver.HttpServerPipelineFactory;
import com.xunlei.netty.httpserver.component.AbstractPageDispatcher;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.netty.httpserver.util.NetUtil;
import com.xunlei.spring.BeanUtil;
import com.xunlei.util.CloseableHelper;
import com.xunlei.util.Log;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerStat;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class Bootstrap {
    public static ApplicationContext CONTEXT;
    private static final Logger log;
    private volatile boolean stopping = false;
    private ExecutorService bossExecutor = HttpServerConfig.bossExecutor;
    private Runnable shutdownRunanble = null;
    @Autowired
    private HttpServerPipelineFactory channelPipelineFactory;
    @Autowired
    private HttpServerConfig config;
    @Autowired
    private AbstractPageDispatcher pageDispatcher;
    private ServerBootstrap serverBootstrap;
    private ServerSocketChannelFactory serverSocketChannelFactory;
    private ExecutorService workerExecutor = HttpServerConfig.workerExecutor;
    private long outterRunnableSpan = 0L;

    static {
        log = Log.getLogger();
    }

    public static ApplicationContext main(String[] args, Runnable initialRunnable, Runnable shutdownRunnalbe, String ... springConfigLocations) throws IOException {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(springConfigLocations);
        CONTEXT = context;
        Bootstrap bootstrap = (Bootstrap)BeanUtil.getTypedBean((ApplicationContext)context, "bootstrap");
        bootstrap.shutdownRunanble = shutdownRunnalbe;
        if (args != null && args.length > 0 && (args[0].toLowerCase().indexOf("stop") >= 0 || args[0].toLowerCase().indexOf("shutdown") >= 0)) {
            bootstrap.sendShutdownCmd();
            System.exit(0);
        } else {
            bootstrap.start(initialRunnable);
        }
        return context;
    }

    public static ApplicationContext main(String[] args, Runnable initialRunnable, String ... springConfigLocations) throws IOException {
        return Bootstrap.main(args, initialRunnable, null, springConfigLocations);
    }

    public static ApplicationContext main(String[] args, String ... springConfigLocations) throws IOException {
        return Bootstrap.main(args, null, null, springConfigLocations);
    }

    private void initEnv() {
        InternalLoggerFactory.setDefaultFactory(new Slf4JLoggerFactory());
        NetUtil.checkSocketPortBind(this.config.getListen_port());
    }

    private void initOutter(Runnable initialRunnable) {
        if (initialRunnable != null) {
            long before = System.currentTimeMillis();
            initialRunnable.run();
            this.outterRunnableSpan = System.currentTimeMillis() - before;
        }
    }

    private void initServer() {
        this.serverSocketChannelFactory = new NioServerSocketChannelFactory(this.bossExecutor, this.workerExecutor, this.config.getRealWorkerCount());
        this.serverBootstrap = new ServerBootstrap(this.serverSocketChannelFactory);
        this.channelPipelineFactory.rebuildPipeline();
        this.serverBootstrap.setPipelineFactory(this.channelPipelineFactory);
        try {
            NioWorkerStat.registerNioWorkers(this.serverSocketChannelFactory);
        }
        catch (Throwable e) {
            log.warn("{}:{}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
        NetUtil.setServerBootstrapOptions(this.serverBootstrap, this.config.getConnectTimeoutMillis(), this.config.getReceiveBufferSize(), this.config.getSendBufferSize());
        ChannelException ex = null;
        try {
            Channel c = this.serverBootstrap.bind(new InetSocketAddress(this.config.getListen_port()));
        }
        catch (ChannelException e) {
            ex = e;
        }
        long span = System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getStartTime();
        String msg = ex == null ? "OK" : "ERROR";
        String chnmsg = ex == null ? "\u670d\u52a1\u5668\u542f\u52a8\u5b8c\u6bd5.(port[" + this.config.getListen_port() + "])" : "\u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25.(port[" + this.config.getListen_port() + "])";
        String outterSpan = this.outterRunnableSpan > 0L ? String.valueOf(this.outterRunnableSpan) + "MS/" : "";
        String spanStr = "[" + outterSpan + span + "MS]";
        String errStr = ex == null ? "" : ex.getMessage();
        HttpServerConfig.ALARMLOG.error("HTTPServer(port[{}],workerCount[{}]) Start {}.{}", new Object[]{this.config.getListen_port(), this.config.getRealWorkerCount(), msg, spanStr, ex});
        System.err.println(String.valueOf(chnmsg) + spanStr + errStr);
        if (ex != null) {
            System.exit(1);
        }
    }

    public void start(Runnable initialRunnable) throws IOException {
        this.initEnv();
        this.pageDispatcher.init();
        this.initOutter(initialRunnable);
        this.initServer();
    }

    public void sendShutdownCmd() {
        block9: {
            HttpURLConnection urlConnection = null;
            LineNumberReader lineReader = null;
            try {
                try {
                    String tmp;
                    URL url = new URL("http://localhost:" + this.config.getListen_port() + "/shutdown");
                    urlConnection = (HttpURLConnection)url.openConnection();
                    urlConnection.setReadTimeout(10000);
                    lineReader = new LineNumberReader(new InputStreamReader(urlConnection.getInputStream()));
                    StringBuilder sb = new StringBuilder();
                    while ((tmp = lineReader.readLine()) != null) {
                        sb.append(tmp);
                    }
                    String returnStr = sb.toString();
                    log.error("shutdown me result:{}", (Object)returnStr);
                }
                catch (Exception e) {
                    log.error("", e);
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                        urlConnection = null;
                    }
                    CloseableHelper.closeSilently(lineReader);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                    urlConnection = null;
                }
                CloseableHelper.closeSilently(lineReader);
                throw throwable;
            }
            if (urlConnection != null) {
                urlConnection.disconnect();
                urlConnection = null;
            }
            CloseableHelper.closeSilently(lineReader);
        }
    }

    public void stop() {
        this.stopping = true;
        String msg = null;
        this.channelPipelineFactory.rebuildPipeline();
        if (this.shutdownRunanble != null) {
            long before = System.currentTimeMillis();
            msg = "shutdownRunanble run begin...";
            log.error(msg);
            System.err.println(msg);
            this.shutdownRunanble.run();
            msg = "shutdownRunanble run end,USING " + (System.currentTimeMillis() - before) + " MS";
            log.error(msg);
            System.err.println(msg);
        }
    }

    public boolean isStop() {
        return this.stopping;
    }
}

