/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.memcached.vo;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import org.apache.log4j.Logger;

public class XLSockIO {
    private static final byte[] B_VERSION = "version\r\n".getBytes();
    private static Logger log = Logger.getLogger(XLSockIO.class.getName());
    private String host;
    private Socket sock;
    private DataInputStream in;
    private BufferedOutputStream out;
    private byte[] recBuf = new byte[this.recBufSize];
    private int recBufSize = 1028;
    private int recIndex = 0;
    private long aliveTimeStamp = 0L;

    public XLSockIO(String host, int port, int timeout, int connectTimeout, boolean noDelay) throws IOException, UnknownHostException {
        this.sock = XLSockIO.getSocket(host, port, connectTimeout);
        if (timeout >= 0) {
            this.sock.setSoTimeout(timeout);
        }
        this.sock.setTcpNoDelay(noDelay);
        this.in = new DataInputStream(this.sock.getInputStream());
        this.out = new BufferedOutputStream(this.sock.getOutputStream());
        this.host = String.valueOf(host) + ":" + port;
    }

    public XLSockIO(String host, int timeout, int connectTimeout, boolean noDelay) throws IOException, UnknownHostException {
        int index = host.indexOf(":");
        if (index <= 0) {
            throw new RuntimeException("host :" + host + " is error,check config file!");
        }
        this.sock = XLSockIO.getSocket(host.substring(0, index), Integer.parseInt(host.substring(index + 1)), connectTimeout);
        if (timeout >= 0) {
            this.sock.setSoTimeout(timeout);
        }
        this.sock.setTcpNoDelay(noDelay);
        this.in = new DataInputStream(this.sock.getInputStream());
        this.out = new BufferedOutputStream(this.sock.getOutputStream());
        this.host = host;
    }

    protected static Socket getSocket(String host, int port, int timeout) throws IOException {
        SocketChannel sock = SocketChannel.open();
        sock.socket().connect(new InetSocketAddress(host, port), timeout);
        return sock.socket();
    }

    public SocketChannel getChannel() {
        return this.sock.getChannel();
    }

    public String getHost() {
        return this.host;
    }

    public void trueClose() throws IOException {
        this.trueClose(true);
    }

    public void trueClose(boolean addToDeadPool) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Closing socket for real: " + this.toString());
        }
        this.aliveTimeStamp = 0L;
        this.recBuf = new byte[this.recBufSize];
        this.recIndex = 0;
        boolean err = false;
        StringBuilder errMsg = new StringBuilder();
        if (this.in == null || this.out == null || this.sock == null) {
            err = true;
            errMsg.append("socket or its streams already null in trueClose call");
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException ioe) {
                log.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519: " + this.toString() + " for host: " + this.getHost());
                log.error(ioe.getMessage(), ioe);
                errMsg.append("\u4ecesocket\u5173\u95ed\u8f93\u5165\u6d41\u51fa: " + this.toString() + " for host: " + this.getHost() + "\n");
                errMsg.append(ioe.getMessage());
                err = true;
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ioe) {
                log.error("\u5173\u95ed\u8f93\u51fa\u6d41\u51fa\u9519: " + this.toString() + " for host: " + this.getHost());
                log.error(ioe.getMessage(), ioe);
                errMsg.append("++++ error closing output stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                errMsg.append(ioe.getMessage());
                err = true;
            }
        }
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException ioe) {
                log.error("\u5173\u95edsocket\u51fa\u9519: " + this.toString() + " for host: " + this.getHost());
                log.error(ioe.getMessage(), ioe);
                errMsg.append("\u5173\u95edsocket\u51fa\u9519: " + this.toString() + " for host: " + this.getHost() + "\n");
                errMsg.append(ioe.getMessage());
                err = true;
            }
        }
        this.in = null;
        this.out = null;
        this.sock = null;
        if (err) {
            throw new IOException(errMsg.toString());
        }
    }

    public void close() {
        try {
            this.sock.close();
            if (log.isDebugEnabled()) {
                log.debug(" \u5173\u95ed socket; \u8fde\u63a5\u72b6\u6001\u4e3a(" + this.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    boolean isConnected() {
        return this.sock != null && this.sock.isConnected();
    }

    boolean isAlive() {
        long interval;
        if (!this.isConnected()) {
            this.aliveTimeStamp = 0L;
            return false;
        }
        boolean needcheck = true;
        if (this.aliveTimeStamp > 0L && (interval = System.currentTimeMillis() - this.aliveTimeStamp) < 100L) {
            needcheck = false;
        }
        if (needcheck) {
            try {
                this.write(B_VERSION);
                this.flush();
                this.readLine();
                this.aliveTimeStamp = System.currentTimeMillis();
            }
            catch (IOException ex) {
                return false;
            }
        }
        return true;
    }

    public byte[] readBytes(int length) throws IOException {
        if (this.sock == null || !this.sock.isConnected()) {
            log.error("\u4ece\u5df2\u7ecf\u5173\u95ed\u7684socket\u8bfb\u6570\u636e");
            throw new IOException("\u4ece\u5df2\u7ecf\u5173\u95ed\u7684socket\u8bfb\u6570\u636e");
        }
        byte[] result = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (this.recIndex >= length) {
            bos.write(this.recBuf, 0, length);
            byte[] newBuf = new byte[this.recBufSize];
            if (this.recIndex > length) {
                System.arraycopy(this.recBuf, length, newBuf, 0, this.recIndex - length);
            }
            this.recBuf = newBuf;
            this.recIndex -= length;
        } else {
            int totalread = length;
            if (this.recIndex > 0) {
                totalread -= this.recIndex;
                bos.write(this.recBuf, 0, this.recIndex);
                this.recBuf = new byte[this.recBufSize];
                this.recIndex = 0;
            }
            int readCount = 0;
            while (totalread > 0) {
                readCount = this.in.read(this.recBuf);
                if (readCount <= 0) continue;
                if (totalread > readCount) {
                    bos.write(this.recBuf, 0, readCount);
                    this.recBuf = new byte[this.recBufSize];
                    this.recIndex = 0;
                } else {
                    bos.write(this.recBuf, 0, totalread);
                    byte[] newBuf = new byte[this.recBufSize];
                    System.arraycopy(this.recBuf, totalread, newBuf, 0, readCount - totalread);
                    this.recBuf = newBuf;
                    this.recIndex = readCount - totalread;
                }
                totalread -= readCount;
            }
        }
        result = bos.toByteArray();
        if (result == null || result != null && result.length <= 0 && this.recIndex <= 0) {
            throw new IOException("\u4ece\u8f93\u51fa\u6d41\u8bfb\u6570\u51fa\u9519,\u5173\u95ed\u8f93\u51fa\u6d41");
        }
        this.aliveTimeStamp = System.currentTimeMillis();
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public String readLine() throws IOException {
        if (this.sock == null || !this.sock.isConnected()) {
            XLSockIO.log.error("\u4ece\u5df2\u7ecf\u5173\u95ed\u7684socket\u8bfb\u6570\u636e");
            throw new IOException("\u4ece\u5df2\u7ecf\u5173\u95ed\u7684socket\u8bfb\u6570\u636e");
        }
        result = null;
        bos = new ByteArrayOutputStream();
        readCount = 0;
        if (this.recIndex <= 0 || !this.read(bos)) ** GOTO lbl11
        return bos.toString();
lbl-1000:
        // 1 sources

        {
            this.recIndex += readCount;
            if (this.read(bos)) break;
lbl11:
            // 2 sources

            ** while ((readCount = this.in.read((byte[])this.recBuf, (int)this.recIndex, (int)(this.recBuf.length - this.recIndex))) > 0)
        }
lbl12:
        // 2 sources

        if ((result = bos.toString()) == null || result != null && result.length() <= 0 && this.recIndex <= 0) {
            throw new IOException("\u4ece\u8f93\u51fa\u6d41\u8bfb\u6570\u51fa\u9519,\u5173\u95ed\u8f93\u51fa\u6d41");
        }
        this.aliveTimeStamp = System.currentTimeMillis();
        return result;
    }

    private boolean read(ByteArrayOutputStream bos) {
        boolean result = false;
        int index = -1;
        int i = 0;
        while (i < this.recIndex - 1) {
            if (this.recBuf[i] == 13 && this.recBuf[i + 1] == 10) {
                index = i;
                break;
            }
            ++i;
        }
        if (index >= 0) {
            bos.write(this.recBuf, 0, index);
            byte[] newBuf = new byte[this.recBufSize];
            if (this.recIndex > index + 2) {
                System.arraycopy(this.recBuf, index + 2, newBuf, 0, this.recIndex - index - 2);
            }
            this.recBuf = newBuf;
            this.recIndex = this.recIndex - index - 2;
            result = true;
        } else if (this.recBuf[this.recIndex - 1] == 13) {
            bos.write(this.recBuf, 0, this.recIndex - 1);
            this.recBuf = new byte[this.recBufSize];
            this.recBuf[0] = 13;
            this.recIndex = 1;
        } else {
            bos.write(this.recBuf, 0, this.recIndex);
            this.recBuf = new byte[this.recBufSize];
            this.recIndex = 0;
        }
        return result;
    }

    public void flush() throws IOException {
        if (this.sock == null || !this.sock.isConnected()) {
            log.error("\u4ece\u5df2\u7ecf\u5173\u95ed\u7684socket\u5199\u6570\u636e");
            throw new IOException("\u4ece\u5df2\u7ecf\u5173\u95ed\u7684socket\u5199\u6570\u636e");
        }
        this.out.flush();
    }

    public void write(byte[] b) throws IOException {
        if (this.sock == null || !this.sock.isConnected()) {
            log.error("\u4ece\u5df2\u7ecf\u5173\u95ed\u7684socket\u5199\u6570\u636e");
            throw new IOException("\u4ece\u5df2\u7ecf\u5173\u95ed\u7684socket\u5199\u6570\u636e");
        }
        this.out.write(b);
    }

    public int hashCode() {
        return this.sock == null ? 0 : this.sock.hashCode();
    }

    public String toString() {
        return this.sock == null ? "" : this.sock.toString();
    }

    protected void finalize() throws Throwable {
        try {
            try {
                if (this.sock != null) {
                    this.sock.close();
                    this.sock = null;
                }
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
                super.finalize();
            }
        }
        finally {
            super.finalize();
        }
    }
}

