/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.memcached.vo;

import com.xunlei.memcached.vo.ApplicationConfigUtil;
import com.xunlei.memcached.vo.XLSockIO;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;

public class SocketUtil {
    protected static Logger logger = Logger.getLogger(SocketUtil.class);
    public static Socket socket;
    public static int socketTimeout;
    public static String host;
    public static String port;

    static {
        port = ApplicationConfigUtil.getMemcachedPort();
        host = ApplicationConfigUtil.getMemcachedHost();
        socketTimeout = ApplicationConfigUtil.getMemcachedTimeout();
    }

    public static Socket getSocketInstance(String host, int port, int timeout) {
        if (socket == null) {
            try {
                socket = new Socket(host, port);
                socket.setSoTimeout(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return socket;
    }

    public static void closeSocket() {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static XLSockIO getSock() {
        String hoststr = String.valueOf(host) + ":" + port;
        XLSockIO sock = SocketUtil.getConnection(hoststr);
        return sock;
    }

    private static XLSockIO getConnection(String hoststr) {
        XLSockIO socket = SocketUtil.createSocket(hoststr);
        return socket;
    }

    private static XLSockIO createSocket(String hoststr) {
        XLSockIO socket = null;
        try {
            socket = new XLSockIO(hoststr, 0, socketTimeout, true);
            if (!socket.isConnected()) {
                logger.error("Sicket \u8fde\u63a5\u5931\u8d25: " + host + " new socket is not connected");
            }
        }
        catch (Exception ex) {
            logger.error("\u83b7\u5f97socket\u8fde\u63a5\u5931\u8d25: " + host);
            socket = null;
        }
        return socket;
    }
}

