/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.json;

import com.xunlei.util.Log;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;

public class JSONEncoder {
    private static final Logger log = Log.getLogger();
    private static final JSONEncoder encoder = new JSONEncoder();
    private static final char[] hex = "0123456789ABCDEF".toCharArray();

    private JSONEncoder() {
    }

    public static String encode(Object value) {
        StringBuilder buf = new StringBuilder();
        try {
            encoder.encode(value, buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buf.toString();
    }

    public void encode(Object value, StringBuilder out) throws IOException {
        this.print(value, out);
    }

    protected void print(Object object, StringBuilder out) throws IOException {
        if (object == null) {
            out.append("null");
        } else if (object instanceof Boolean) {
            out.append(String.valueOf(object));
        } else if (object instanceof Number) {
            out.append(String.valueOf(object));
        } else if (object instanceof Class) {
            this.printDirectly(((Class)object).getName(), out);
        } else if (object instanceof String) {
            this.print((String)object, out);
        } else if (object instanceof Character) {
            this.print(String.valueOf(object), out);
        } else if (object instanceof Map) {
            this.print((Map)object, out);
        } else if (object instanceof Object[]) {
            this.print((Object[])object, out);
        } else if (object instanceof Iterator) {
            this.print((Iterator)object, out);
        } else if (object instanceof Enumeration) {
            this.print((Enumeration)object, out);
        } else if (object instanceof Collection) {
            this.print((Collection)object, out);
        } else {
            this.printBean(object, out);
        }
    }

    private void unicode(StringBuilder out, char c) {
        out.append("\\u");
        int n = c;
        int i = 0;
        while (i < 4) {
            int digit = (n & 0xF000) >> 12;
            out.append(hex[digit]);
            n <<= 4;
            ++i;
        }
    }

    protected void printDirectly(String text, StringBuilder out) throws IOException {
        out.append('\"');
        out.append(text);
        out.append('\"');
    }

    protected void print(String text, StringBuilder out) throws IOException {
        out.append('\"');
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\"' || c == '\\') {
                out.append('\\');
                out.append(c);
            } else if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                switch (c) {
                    case '\b': {
                        out.append("\\b");
                        break;
                    }
                    case '\t': {
                        out.append("\\t");
                        break;
                    }
                    case '\n': {
                        out.append("\\n");
                        break;
                    }
                    case '\f': {
                        out.append("\\f");
                        break;
                    }
                    case '\r': {
                        out.append("\\r");
                        break;
                    }
                    default: {
                        this.unicode(out, c);
                        break;
                    }
                }
            } else {
                out.append(c);
            }
            ++i;
        }
        out.append('\"');
    }

    protected void printBean(Object object, StringBuilder out) throws IOException {
        out.append('{');
        boolean addedSomething = false;
        try {
            BeanInfo info = Introspector.getBeanInfo(object.getClass());
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            int i = 0;
            while (i < props.length) {
                Method accessor;
                PropertyDescriptor prop = props[i];
                if (!Class.class.equals(prop.getPropertyType()) && (accessor = prop.getReadMethod()) != null) {
                    if (!accessor.isAccessible()) {
                        accessor.setAccessible(true);
                    }
                    Object value = accessor.invoke(object, new Object[0]);
                    if (addedSomething) {
                        out.append(',');
                    }
                    String name = prop.getName();
                    this.printDirectly(name, out);
                    out.append(':');
                    this.print(value, out);
                    addedSomething = true;
                }
                ++i;
            }
        }
        catch (IllegalAccessException iae) {
            log.error("", iae);
        }
        catch (InvocationTargetException ite) {
            log.error("", ite);
        }
        catch (IntrospectionException ie) {
            log.error("", ie);
        }
        out.append('}');
    }

    protected void print(Map<?, ?> map, StringBuilder out) throws IOException {
        out.append('{');
        boolean addedSomething = false;
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (addedSomething) {
                out.append(',');
            }
            addedSomething = true;
            this.print(String.valueOf(e.getKey()), out);
            out.append(':');
            this.print(e.getValue(), out);
        }
        out.append('}');
    }

    protected void print(Object[] object, StringBuilder out) throws IOException {
        out.append('[');
        int i = 0;
        while (i < object.length) {
            if (i > 0) {
                out.append(',');
            }
            this.print(object[i], out);
            ++i;
        }
        out.append(']');
    }

    protected void print(Collection<?> collecion, StringBuilder out) throws IOException {
        out.append('[');
        boolean addedSomething = false;
        for (Object obj : collecion) {
            if (addedSomething) {
                out.append(',');
            }
            addedSomething = true;
            this.print(obj, out);
        }
        out.append(']');
    }

    protected void print(Iterator<?> it, StringBuilder out) throws IOException {
        out.append('[');
        while (it.hasNext()) {
            this.print(it.next(), out);
            if (!it.hasNext()) continue;
            out.append(',');
        }
        out.append(']');
    }

    protected void print(Enumeration<?> it, StringBuilder out) throws IOException {
        out.append('[');
        while (it.hasMoreElements()) {
            this.print(it.nextElement(), out);
            if (!it.hasMoreElements()) continue;
            out.append(',');
        }
        out.append(']');
    }
}

