/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.httptool.util;

import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.springutil.MailTemplate;
import com.xunlei.util.EmptyChecker;
import com.xunlei.util.HttpUtil;
import com.xunlei.util.Log;
import com.xunlei.util.StringHelper;
import com.xunlei.util.StringTools;
import com.xunlei.util.ValueUtil;
import java.io.File;
import java.io.FileInputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class ErrorReporter {
    private static long lastModified;
    private static final Logger logger;
    private static String[] mailList;
    private static MailTemplate mailTemplate;
    private static String resource;
    private static boolean sendErrorMail;
    private static URL url;

    static {
        logger = Log.getLogger();
        resource = "errorreporter.properties";
        sendErrorMail = false;
        url = ErrorReporter.class.getClassLoader().getResource(resource);
        ErrorReporter.loadConfig();
    }

    public static String getMailSubject(String subject) {
        return "[" + HttpUtil.getLocalSampleIP() + "-" + ManagementFactory.getRuntimeMXBean().getName() + "]" + subject;
    }

    public static void loadConfig() {
        if (url != null) {
            try {
                File file = new File(url.getFile());
                if (file.exists() && file.lastModified() != lastModified) {
                    lastModified = file.lastModified();
                    Properties prop = new Properties();
                    prop.load(new FileInputStream(file));
                    sendErrorMail = ValueUtil.getBoolean(prop.getProperty("send_error_mail"), false);
                    JavaMailSenderImpl jms = new JavaMailSenderImpl();
                    jms.setHost(prop.getProperty("host").toString());
                    jms.setUsername(prop.getProperty("username"));
                    jms.setPassword(prop.getProperty("password"));
                    MailTemplate mt = new MailTemplate(jms, prop.getProperty("from_addr"));
                    mt.setMaxRetryTime(ValueUtil.getInteger(prop.getProperty("max_retry_time"), 0));
                    mt.setRetryIdle(ValueUtil.getLong(prop.getProperty("retry_idle"), 0L));
                    mailList = StringTools.splitAndTrimAsArray(prop.getProperty("mail_list"), ",");
                    mailTemplate = mt;
                }
            }
            catch (Throwable e) {
                logger.error("", e);
            }
        }
    }

    public static void report(Logger log, Throwable e, Object obj) {
        StringBuilder sb = new StringBuilder(obj.toString());
        sb.append("STACK_TRACE:\r\n");
        sb.append((CharSequence)StringHelper.printThrowable(e));
        if (log != null) {
            log.error("{}", sb);
        }
        String title = e == null ? "null" : e.getClass().getSimpleName();
        ErrorReporter.sendReportMail(title, sb.toString());
    }

    public static void report(Logger log, Throwable e, XLHttpRequest request) {
        String title = StringHelper.concate(e == null ? "null" : e.getClass().getSimpleName(), ": ", request.getRemoteIP(), ": ", request.getUri());
        ErrorReporter.report(log, e, request, title, "");
    }

    public static void report(Logger log, Throwable e, XLHttpRequest request, String title, String extraMessage) {
        StringBuilder sb = new StringBuilder(extraMessage);
        sb.append("REQUEST_URI: " + request.getUri() + "\r\n");
        sb.append("STACK_TRACE:\r\n");
        sb.append((CharSequence)StringHelper.printThrowable(e));
        StringHelper.printLine(sb, 100, '-');
        sb.append((CharSequence)request.getDetailInfo());
        if (log != null) {
            log.error("{}", sb);
        }
        ErrorReporter.loadConfig();
        if (sendErrorMail) {
            ErrorReporter.sendReportMail(title, sb.toString());
        }
    }

    public static void sendReportMail(final String subject, final String content) {
        if (!sendErrorMail) {
            return;
        }
        try {
            if (mailTemplate != null && EmptyChecker.isNotEmpty(mailList)) {
                HttpServerConfig.daemonTaskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        mailTemplate.sendTextMail(mailList, ErrorReporter.getMailSubject(subject), content);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("", e);
        }
    }

    private ErrorReporter() {
    }
}

