/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.httptool;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.httptool.util.RtnError;
import com.xunlei.json.JSONUtil;
import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.AbstractHttpServerError;
import com.xunlei.netty.httpserver.exception.IllegalParameterError;
import com.xunlei.netty.httpserver.handler.PlainHandler;
import com.xunlei.netty.httpserver.handler.TextResponseHandler;
import com.xunlei.spring.AfterConfig;
import com.xunlei.spring.Config;
import com.xunlei.util.StringHelper;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JsonHandler
extends TextResponseHandler {
    @Config
    private String defaultCallbackName = "callback";
    @Autowired
    private PlainHandler plainHandler;

    @AfterConfig
    public void registerHandler() {
        this.textResponseHandlerManager.addFirst(this);
    }

    @Override
    public String buildContentString(XLContextAttachment attach, Object cmdReturnObj) {
        XLHttpResponse response = attach.getResponse();
        XLHttpResponse.ContentType type = response.getInnerContentType();
        if (!type.equals((Object)XLHttpResponse.ContentType.json)) {
            return null;
        }
        response.setHeaderIfEmpty("Content-Type", "text/plain; charset=" + response.getContentCharset());
        StringBuilder content = this.handleResponse(attach, cmdReturnObj);
        this.plainHandler.appendDebugInfo(attach, content);
        return content.toString();
    }

    public StringBuilder handleResponse(XLContextAttachment attach, Object cmdReturnObj) {
        Object obj;
        XLHttpRequest request = attach.getRequest();
        boolean onlyJson = request.getParameterBoolean("onlyjson", false);
        String callback = "";
        if (!onlyJson) {
            callback = request.getParameter("callback");
            if (callback == null) {
                callback = this.defaultCallbackName;
            } else if (callback.contains("<")) {
                callback = "OOPS Character Illegal : <\n";
            }
        }
        Object rtnObj = null;
        rtnObj = cmdReturnObj == null ? JsonObjectUtil.getRtnAndDataJsonObject(500, JsonObjectUtil.buildMap("msg", this.responseReturnNullInfo)) : cmdReturnObj;
        Object object = obj = rtnObj instanceof String ? rtnObj : JSONUtil.fromObject(rtnObj);
        if (onlyJson) {
            return new StringBuilder().append(obj);
        }
        return new StringBuilder(callback).append('(').append(obj).append(')');
    }

    @Override
    public Object handleThrowable(XLContextAttachment attach, Throwable ex) throws Exception {
        XLHttpResponse response = attach.getResponse();
        XLHttpRequest request = attach.getRequest();
        XLHttpResponse.ContentType type = response.getInnerContentType();
        if (!type.equals((Object)XLHttpResponse.ContentType.json)) {
            return null;
        }
        if (ex instanceof RtnError) {
            return ((RtnError)ex).getJson();
        }
        if (ex instanceof IllegalParameterError) {
            return JsonObjectUtil.getRtnAndDataJsonObject(9, JsonObjectUtil.buildMap("msg", ex.getMessage()));
        }
        if (ex instanceof AbstractHttpServerError) {
            HttpResponseStatus status = ((AbstractHttpServerError)ex).getStatus();
            response.setStatus(status);
            return JsonObjectUtil.getRtnAndDataJsonObject(500, JsonObjectUtil.buildMap("msg", ex.getMessage()));
        }
        this.logThrowable(attach, request, response, ex);
        return JsonObjectUtil.getRtnAndDataJsonObject(500, JsonObjectUtil.buildMap("msg", StringHelper.printThrowableSimple(ex)));
    }
}

