/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.RoleRights;
import com.xunlei.common.vo.Users;
import com.xunlei.common.web.bean.OperatEntry;
import com.xunlei.common.web.model.AbstractManagedBean;
import java.io.UnsupportedEncodingException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FunRef(value="UserRight")
public class UserRightManagedBean
extends AbstractManagedBean {
    private List<OperatEntry> optlist;
    private String curruserlogno;
    private String currtruename;
    private String currentmoduleno;

    private String getCurrUserLogNo() {
        if (this.isEmpty(this.curruserlogno)) {
            this.curruserlogno = this.findParameter("users2_userlogno");
        }
        return this.curruserlogno;
    }

    private String getCurrUserTruename() {
        if (this.isEmpty(this.currtruename) && this.isNotEmpty(this.findParameter("users2_truename"))) {
            try {
                this.currtruename = new String(this.findParameter("users2_truename").getBytes("iso-8859-1"), "utf8");
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
        }
        return this.currtruename;
    }

    private Users getQueryUser() {
        Users data = this.findBean(Users.class, 2);
        if (this.isEmpty(data.getUserlogno())) {
            data.setUserlogno(this.getCurrUserLogNo());
        }
        if (this.isEmpty(data.getTruename())) {
            data.setTruename(this.getCurrUserTruename());
        }
        return data;
    }

    public String getCurrModuleNo() {
        if (this.isEmpty(this.currentmoduleno)) {
            this.currentmoduleno = this.findParameter("currentmoduleno");
        }
        return this.currentmoduleno;
    }

    public void setCurrModuleNo(String moduleno) {
        this.currentmoduleno = moduleno;
    }

    public List<LibClassD> getAllmodules() {
        this.authenticateRun();
        Users user = this.getQueryUser();
        try {
            return commfacade.getAllmodules(user);
        }
        catch (Exception ex) {
            this.alertJS(ex.getMessage());
            return null;
        }
    }

    public String getQueryUserrights() {
        this.authenticateRun();
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("roleno asc");
        Users user = this.getQueryUser();
        List<RoleRights> list = commfacade.getUserrights(user, this.getCurrModuleNo(), fliper.getSortColumn());
        if (list == null || list.size() == 0) {
            this.mergePagedDataModel(Sheet.EMPTY, fliper);
            return "";
        }
        for (RoleRights rr : list) {
            rr.setAllpluses(this.getAllPlusOperation());
        }
        this.mergePagedDataModel(new Sheet<RoleRights>(list.size(), list), fliper);
        return "";
    }

    public List<OperatEntry> getAllPlusOperation() {
        if (this.optlist == null) {
            this.optlist = OperatEntry.transfer(commfacade.getAllPlusOperation());
        }
        return this.optlist;
    }

    public String getColumnStyleClass() {
        String str = ",,columncenter30,columncenter30,columncenter30,columncenter30";
        int len = this.getAllPlusOperation().size();
        for (int i = 0; i < len; ++i) {
            str = str + ",columncenter30";
        }
        str = str + ",columncenter70";
        return str;
    }
}

