/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.Functions;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.RoleRights;
import com.xunlei.common.vo.Roles;
import com.xunlei.common.web.bean.OperatEntry;
import com.xunlei.common.web.model.AbstractManagedBean;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FunRef(value="RoleRights")
public class RoleRightManagedBean
extends AbstractManagedBean {
    private List<Roles> sysrolelist;
    private List<OperatEntry> optlist;
    private List<Functions> funclist;
    private List<SelectItem> funcitems;
    private String currentfuncno = null;
    private String currentroleno = null;
    private String currentmoduleno = null;

    public RoleRights createAddingbean() {
        this.funclist = null;
        RoleRights data = new RoleRights();
        if (!this.getFunclist().isEmpty()) {
            Functions currfunc = this.funclist.get(0);
            for (Functions f : this.funclist) {
                if (!f.getFuncno().equals(this.getCurrentfuncno())) continue;
                currfunc = f;
                break;
            }
            if (!(data = new RoleRights(currfunc)).isBoolenablerun()) {
                data.setEnablerun((short)-1);
            }
            if (!data.isBoolenableadd()) {
                data.setEnableadd((short)-1);
            }
            if (!data.isBoolenableedit()) {
                data.setEnableedit((short)-1);
            }
            if (!data.isBoolenabledel()) {
                data.setEnabledel((short)-1);
            }
            data.setFuncfullplus(currfunc.getHaveplus());
        }
        data.setRoleno(this.getCurrentroleno());
        data.setAllpluses(this.getAllPlusOperation());
        return data;
    }

    public boolean isHasCanChooseFuncs() {
        return !this.getCanChooseFuncs().isEmpty();
    }

    private List<Functions> getFunclist() {
        if (this.funclist == null) {
            this.initnos();
            this.funclist = commfacade.getFunctionsNotInRoles(this.currentmoduleno, this.currentroleno);
        }
        return this.funclist;
    }

    public List<SelectItem> getCanChooseFuncs() {
        this.mergeBean((Object)this.createAddingbean(), 2);
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(this.getFunclist().size());
        for (Functions fun : this.funclist) {
            items.add(new SelectItem((Object)fun.getFuncno(), fun.getFuncname()));
        }
        this.funcitems = items;
        return this.funcitems;
    }

    public String add() {
        this.authenticateAdd();
        RoleRights data = this.findBean(RoleRights.class, 2);
        if (data.getEnablerun() < 0) {
            data.setEnablerun((short)0);
        }
        if (data.getEnableadd() < 0) {
            data.setEnableadd((short)0);
        }
        if (data.getEnableedit() < 0) {
            data.setEnableedit((short)0);
        }
        if (data.getEnabledel() < 0) {
            data.setEnabledel((short)0);
        }
        commfacade.insertRoleRights(data);
        this.newBean();
        return "";
    }

    public String delete() {
        this.authenticateDel();
        commfacade.removeRoleRights(this.findParamSeqid());
        return "";
    }

    public String deleteSome() {
        this.authenticateDel();
        for (long seqid : this.findParamSeqids()) {
            commfacade.removeRoleRights(seqid);
        }
        return "";
    }

    public String edit() {
        this.authenticateEdit();
        RoleRights data = this.findBean(RoleRights.class);
        commfacade.updateRoleRights(data);
        this.newBean();
        return "";
    }

    private void initnos() {
        if (this.currentroleno == null) {
            String roleno;
            this.currentroleno = roleno = this.findParameter("currentroleno");
            if (this.currentroleno == null) {
                this.getAllsysroles();
            }
        }
        if (this.currentmoduleno == null) {
            String moduleno;
            this.currentmoduleno = moduleno = this.findParameter("currentmoduleno");
            if (this.currentmoduleno == null) {
                this.getAllmodules();
            }
        }
    }

    public String getColumnStyleClass() {
        String str = "columncenter20,,,columncenter30,columncenter30,columncenter30,columncenter30,columncenter30";
        int len = this.getAllPlusOperation().size();
        for (int i = 0; i < len; ++i) {
            str = str + ",columncenter30";
        }
        str = str + ",columncenter70";
        return str;
    }

    private void newBean() {
        RoleRights data = new RoleRights();
        data.setRoleno(this.getCurrentroleno());
        data.setAllpluses(this.getAllPlusOperation());
        this.mergeBean(data);
    }

    public List<OperatEntry> getAllPlusOperation() {
        if (this.optlist == null) {
            this.optlist = OperatEntry.transfer(commfacade.getAllPlusOperation());
        }
        return this.optlist;
    }

    public List<Roles> getAllsysroles() {
        this.authenticateRun();
        this.sysrolelist = commfacade.getAllSysRoles();
        if (this.currentroleno == null && this.sysrolelist.size() > 0) {
            this.currentroleno = this.sysrolelist.get(0).getRoleno();
        }
        return this.sysrolelist;
    }

    public List<LibClassD> getAllmodules() {
        this.authenticateRun();
        List<LibClassD> list = commfacade.getLibClassDByClassNo("SysModule");
        if (this.currentmoduleno == null && list.size() > 0) {
            this.currentmoduleno = list.get(0).getClassitemid();
        }
        return list;
    }

    public String getQueryRolerights() {
        this.authenticateRun();
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("roleno asc");
        this.funclist = null;
        this.mergeBean((Object)this.createAddingbean(), 2);
        List<RoleRights> list = commfacade.getRoleRightsByRoleNoAndModuleNo(this.currentroleno, this.currentmoduleno, fliper.getSortColumn());
        this.newBean();
        this.mergePagedDataModel(new Sheet<RoleRights>(list.size(), list), fliper);
        return "";
    }

    public String getCurrentParam() {
        this.initnos();
        String str = "";
        str = str + "<input type='hidden' id='currentroleno' name='currentroleno' value='" + this.getCurrentroleno() + "' >";
        str = str + "<input type='hidden' id='currentmoduleno' name='currentmoduleno' value='" + this.getCurrentmoduleno() + "' >";
        return str;
    }

    public String getCurrentroleno() {
        return this.currentroleno;
    }

    public void setCurrentroleno(String currentroleno) {
        if (currentroleno != null) {
            this.currentroleno = currentroleno;
        }
    }

    public String getCurrentmoduleno() {
        return this.currentmoduleno;
    }

    public void setCurrentmoduleno(String currentmoduleno) {
        if (currentmoduleno != null) {
            this.currentmoduleno = currentmoduleno;
        }
    }

    public String getCurrentfuncno() {
        return this.findParameter("funcno2");
    }

    public void setCurrentfuncno(String currentfuncno) {
        if (currentfuncno != null) {
            this.currentfuncno = currentfuncno;
        }
    }
}

