/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.Functions;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.common.vo.UserToRole;
import com.xunlei.common.vo.Users;
import com.xunlei.common.web.bean.OperatEntry;
import com.xunlei.common.web.model.AbstractManagedBean;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FunRef(value="Functions")
public class FunctionManagedBean
extends AbstractManagedBean {
    private List<OperatEntry> optlist;

    private Functions findQueryBean() {
        Functions bean = this.findBean(Functions.class, 2);
        List<SelectItem> items = this.getSysmodules();
        if (this.isEmpty(bean.getModuleno()) && items.size() > 0) {
            bean.setModuleno("" + items.get(0).getValue());
        }
        return bean;
    }

    public String getQueryFunctionslist() {
        this.authenticateRun();
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("funcno asc");
        Sheet<Functions> sheet = commfacade.queryFunctions(this.findQueryBean(), fliper);
        this.mergePagedDataModel(sheet, fliper);
        return "";
    }

    public List<SelectItem> getSysmodules() {
        ArrayList<SelectItem> list = (ArrayList<SelectItem>)this.getRequestAttribute("sysmodules");
        if (list == null) {
            List<LibClassD> datas = LibClassM.getLibClassDList("SysModule");
            list = new ArrayList<SelectItem>(datas.size());
            for (int i = 0; i < datas.size(); ++i) {
                list.add(new SelectItem((Object)datas.get(i).getClassitemid(), datas.get(i).getItemname()));
            }
            this.setRequestAttribute("sysmodules", list);
        }
        return list;
    }

    public List<SelectItem> getSysmodulesByUserlogno() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        UserInfo userInfo = this.currentUserInfo();
        List<LibClassD> listModule = commfacade.queryLibClassdsByUserlogno(userInfo);
        if (listModule != null) {
            for (LibClassD lib : listModule) {
                list.add(new SelectItem((Object)lib.getClassitemid(), lib.getItemname()));
            }
        }
        return list;
    }

    @Deprecated
    public List<SelectItem> getUserSysmodules() {
        List lastlist = (List)this.getRequestAttribute("mysysmodules");
        if (lastlist == null) {
            String moduleNo = null;
            UserInfo userInfo = this.currentUserInfo();
            List<Object> list = new ArrayList();
            ArrayList<SelectItem> rlist = new ArrayList<SelectItem>();
            list = userInfo.isSuperman() ? this.getSysmodules() : this.getSysmodulesByUserlogno();
            Users users = new Users();
            users.setUserlogno(userInfo.getUserlogno());
            Sheet<UserToRole> sheet = commfacade.getRolesByUser(users, null);
            List roleList = (List)sheet.getDatas();
            if (roleList != null && roleList.size() > 0) {
                if (this.isEmpty(moduleNo)) {
                    moduleNo = ((UserToRole)roleList.get(0)).getClassitemid();
                }
                if (this.isNotEmpty(moduleNo)) {
                    rlist.add(0, new SelectItem((Object)moduleNo, "\u6211\u7684\u5de5\u4f5c\u53f0"));
                    for (SelectItem item : list) {
                        if (item.getValue().equals(moduleNo)) continue;
                        rlist.add(item);
                    }
                }
            }
            if (this.isEmpty(moduleNo)) {
                this.setRequestAttribute("mysysmodules", list);
                return list;
            }
            this.setRequestAttribute("mysysmodules", rlist);
            return rlist;
        }
        return lastlist;
    }

    public List<OperatEntry> getAllPlusOperation() {
        if (this.optlist == null) {
            this.optlist = OperatEntry.transfer(commfacade.getAllPlusOperation());
        }
        return this.optlist;
    }

    public String getColumnStyleClass() {
        String str = "columncenter20,,,columncenter30,columncenter30,columncenter30,columncenter30";
        int len = this.getAllPlusOperation().size();
        for (int i = 0; i < len; ++i) {
            str = str + ",columncenter30";
        }
        str = str + ",columncenter40";
        return str;
    }

    public String add() {
        this.authenticateAdd();
        Functions data = this.findBean(Functions.class);
        data.setHaverun((short)1);
        try {
            commfacade.insertFunctions(data);
        }
        catch (XLRuntimeException e) {
            this.mergeBean((Object)e.getMessage(), "jsmessage");
        }
        this.getQueryFunctionslist();
        return "";
    }

    public String delete() {
        this.authenticateDel();
        commfacade.removeFunctions(commfacade.getFunctionsById(this.findParamSeqid()));
        return "";
    }

    public String deleteSome() {
        this.authenticateDel();
        try {
            for (long seqid : this.findParamSeqids()) {
                commfacade.removeFunctions(commfacade.getFunctionsById(seqid));
            }
        }
        catch (XLRuntimeException e) {
            this.alertJS(e.getMessage());
        }
        this.getQueryFunctionslist();
        return "";
    }

    public String edit() {
        this.authenticateEdit();
        Functions data = this.findBean(Functions.class);
        data.setHaverun((short)1);
        try {
            commfacade.updateFunctions(data);
        }
        catch (XLRuntimeException e) {
            this.mergeBean((Object)e.getMessage(), "jsmessage");
        }
        this.getQueryFunctionslist();
        return "";
    }
}

