/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.web.model.FileNameNode;
import java.util.ArrayList;
import java.util.List;

class FileNameHandle {
    private List<FileNameNode> fileNameList;
    private FileNameNode currentNode;
    private int fileCount;
    private boolean searchByFileName;

    public FileNameHandle(String filesavenameWithext, String filemsg, int fileCount) {
        this.fileCount = fileCount;
        this.fileNameList = new ArrayList<FileNameNode>();
        if (StringTools.isNotEmpty(filesavenameWithext) || StringTools.isEmpty(filesavenameWithext) && StringTools.isEmpty(filemsg)) {
            this.searchByFileName = false;
            if (StringTools.isEmpty(filesavenameWithext)) {
                filesavenameWithext = StringTools.getTradeSn() + System.currentTimeMillis();
            }
            if (fileCount == 1) {
                FileNameNode fn = new FileNameNode("", filesavenameWithext, 0, 0);
                this.fileNameList.add(fn);
            } else {
                for (int i = 1; i <= fileCount; ++i) {
                    FileNameNode fn = new FileNameNode("", filesavenameWithext + "_" + i, 0, 0);
                    this.fileNameList.add(fn);
                }
            }
        } else {
            this.searchByFileName = true;
            String[] filemsgsplit = filemsg.split(",");
            if (filemsgsplit.length != fileCount) {
                throw new XLRuntimeException("\u6587\u4ef6\u6570\u8ddf\u63d0\u4ea4\u4e0a\u6765\u7684\u6587\u4ef6\u547d\u540d\u6570\u4e0d\u76f8\u540c\uff0cfilemsg Length:" + filemsgsplit.length + ",fileCount:" + fileCount);
            }
            for (int i = 0; i < fileCount; ++i) {
                FileNameNode fn = FileNameNode.parseToFileNameNode(filemsgsplit[i]);
                this.fileNameList.add(fn);
            }
        }
    }

    public String getFileName(String filename) {
        filename = filename.toLowerCase();
        for (int i = 0; i < this.fileCount; ++i) {
            FileNameNode current = this.fileNameList.get(i);
            if (this.searchByFileName) {
                if (!current.getFilename().equals(filename)) continue;
                this.currentNode = current;
                break;
            }
            if (current.isAlreadyGet()) continue;
            this.currentNode = current;
            break;
        }
        this.currentNode.setAlreadyGet(true);
        return this.currentNode.getSavename();
    }

    public void setCurrentUploadSuccess(boolean success) {
        this.currentNode.setUploadSuccess(success);
    }

    public void setCurrentExt(String ext) {
        this.currentNode.setExt(ext);
    }

    public int getCurrentWidth() {
        return this.currentNode.getWidth();
    }

    public int getCurrentHeight() {
        return this.currentNode.getHeight();
    }

    public String toSuccessString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fileNameList.size(); ++i) {
            FileNameNode cn = this.fileNameList.get(i);
            sb.append(cn.isUploadSuccess());
            if (i >= this.fileNameList.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String toSaveFileNameString(boolean wantThumbInfo) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fileNameList.size(); ++i) {
            FileNameNode cn = this.fileNameList.get(i);
            sb.append(cn.getFileFullName());
            if (wantThumbInfo) {
                sb.append("," + cn.getWidth() + "," + cn.getHeight());
            }
            if (i >= this.fileNameList.size() - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        FileNameHandle fnh = new FileNameHandle("", "ouerer|ojerer|0|0,ouedfdrer|ojerer|0|0,ouedfererer|ojecccccrer|0|0", 3);
        for (int i = 0; i < 3; ++i) {
            System.out.println(fnh.getFileName("ouedfererer"));
        }
    }
}

