/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.UserCookie;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.Functionlogs;
import com.xunlei.common.vo.Functions;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.common.vo.LibConfig;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.common.web.bean.PagedDataModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.jsf.FacesContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManagedBean {
    protected static Log logger = LogFactory.getLog(AbstractManagedBean.class);
    protected static final IFacadeCommon commfacade = (IFacadeCommon)WebApplicationContextUtils.getWebApplicationContext(FacesContextUtils.getWebApplicationContext(FacesContext.getCurrentInstance()).getServletContext()).getBean("facadeCommonImpl");

    protected AbstractManagedBean() {
    }

    protected PagedDataModel mergePagedDataModel(Sheet<?> sheet, PagedFliper ... flipers) {
        int index;
        if (flipers == null || flipers.length == 0) {
            flipers = new PagedFliper[]{new PagedFliper()};
        }
        String name = (index = flipers[0].getIndex()) > 1 ? "datamodel" + index : "datamodel";
        PagedDataModel model = new PagedDataModel(sheet, flipers[0], index);
        this.mergeBean((Object)model, name);
        for (PagedFliper fliper : flipers) {
            if (fliper.getIndex() > 1) {
                this.mergeBean((Object)fliper, "fliper" + fliper.getIndex());
                continue;
            }
            this.mergeBean((Object)fliper, "fliper");
        }
        return model;
    }

    protected PagedFliper getFliper() {
        return this.getFliper(0);
    }

    protected PagedFliper getFliper(int index) {
        int pagesize;
        String sortcolumn;
        PagedFliper fliper = new PagedFliper();
        fliper.setIndex(index);
        String pageno = this.findParameter(AbstractManagedBean.getHiddenPageNoId(index));
        if (!this.isEmpty(pageno)) {
            fliper.setPageNo(Integer.parseInt(pageno));
        }
        if (!this.isEmpty(sortcolumn = this.findParameter(AbstractManagedBean.getHiddenSortColumnId(index)))) {
            fliper.setSortColumn(sortcolumn);
        }
        if ((pagesize = this.getPageSize(index, fliper)) > 0) {
            fliper.setPageSize(pagesize);
        }
        return fliper;
    }

    private static String getHiddenPageNoId(int index) {
        return "__hidden_pageno_" + (index < 2 ? "" : "" + index);
    }

    private static String getHiddenSortColumnId(int index) {
        return "__hidden_sortcolumn_" + (index < 2 ? "" : "" + index);
    }

    private static String getHiddenPageSizeId(int index) {
        return "__hidden_pagesize_" + (index < 2 ? "" : "" + index);
    }

    protected <T> T findBean(Class<T> clazz) {
        return this.findBean(clazz, clazz.getSimpleName().toLowerCase());
    }

    protected <T> T findBean(Class<T> clazz, int i) {
        return this.findBean(clazz, clazz.getSimpleName().toLowerCase() + i);
    }

    protected <T> T findBean(Class<T> clazz, String beanName) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elcontext = context.getELContext();
        ExpressionFactory factory = context.getApplication().getExpressionFactory();
        ValueExpression exp = factory.createValueExpression(elcontext, "#{" + beanName + "}", clazz);
        return (T)exp.getValue(elcontext);
    }

    protected void mergeBean(Object bean) {
        this.mergeBean(bean, bean.getClass().getSimpleName().toLowerCase());
    }

    protected void mergeBean(Object bean, int i) {
        this.mergeBean(bean, bean.getClass().getSimpleName().toLowerCase() + i);
    }

    protected void mergeBean(Object bean, String beanName) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elcontext = context.getELContext();
        ExpressionFactory factory = context.getApplication().getExpressionFactory();
        ValueExpression exp = factory.createValueExpression(elcontext, "#{" + beanName + "}", bean.getClass());
        exp.setValue(elcontext, bean);
    }

    protected HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
    }

    protected HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
    }

    protected void setRequestAttribute(String name, Object obj) {
        this.getHttpServletRequest().setAttribute(name, obj);
    }

    protected <T> T getRequestAttribute(String name) {
        return (T)this.getHttpServletRequest().getAttribute(name);
    }

    public String getContextPath() {
        return this.getHttpServletRequest().getContextPath();
    }

    public String getClientAddr() {
        return this.getHttpServletRequest().getRemoteAddr();
    }

    protected long findParamSeqid() {
        return this.findParamLong("param_seqid");
    }

    protected long[] findParamSeqids() {
        String paramseqids = this.findParameter("param_seqid");
        if (this.isEmpty(paramseqids)) {
            paramseqids = this.findParameter("delseqids");
        }
        if (this.isEmpty(paramseqids)) {
            paramseqids = this.findParameter("delbtn");
        }
        String[] params = paramseqids.split(",");
        long[] seqids = new long[params.length];
        for (int i = 0; i < seqids.length; ++i) {
            seqids[i] = Long.parseLong(params[i]);
        }
        return seqids;
    }

    protected long[] parseSeqidArray(String str) {
        if (this.isNotEmpty(str)) {
            String[] strs = str.split(",");
            long[] res = new long[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                res[i] = Long.parseLong(strs[i]);
            }
            return res;
        }
        return null;
    }

    protected float findParamFloat(String param) {
        return Float.parseFloat(this.findParameter(param));
    }

    protected short findParamShort(String param) {
        return Short.parseShort(this.findParameter(param));
    }

    protected int findParamInt(String param) {
        return Integer.parseInt(this.findParameter(param));
    }

    protected long findParamLong(String param) {
        return Long.parseLong(this.findParameter(param));
    }

    protected String findParameter(String name) {
        HttpServletRequest request = this.getHttpServletRequest();
        return request.getParameter(name);
    }

    protected String[] findParameters(String name) {
        HttpServletRequest request = this.getHttpServletRequest();
        return request.getParameterValues(name);
    }

    protected void alertJS(String message) {
        String jsmessage = "<script type=\"text/javascript\">alert(\"" + StringTools.escapeJs(message) + "\");</script>";
        this.mergeBean((Object)jsmessage, "jsmessage");
    }

    protected void mergeJsmessage(String msg) {
        this.mergeBean((Object)msg, "jsmessage");
    }

    protected final String now() {
        return DatetimeUtil.now();
    }

    protected final boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0 || "null".equalsIgnoreCase(str);
    }

    protected final boolean isNotEmpty(String str) {
        return str != null && str.trim().length() > 0 && !"null".equalsIgnoreCase(str);
    }

    protected String currentUserLogo() {
        UserInfo userinfo = this.currentUserInfo();
        return userinfo == null ? null : userinfo.getUserlogno();
    }

    protected UserInfo currentUserInfo() {
        return (UserInfo)this.getHttpServletRequest().getSession(true).getAttribute("userinfo");
    }

    protected final void authenticateAdd() {
        this.authenticate("add");
    }

    protected final void authenticateEdit() {
        this.authenticate("edit");
    }

    protected final void authenticateDel() {
        this.authenticate("del");
    }

    protected final void authenticateRun() {
        this.authenticate("run");
    }

    public final boolean isEnableAdd() {
        return this.isEnableOperate("add");
    }

    public final boolean isEnableEdit() {
        return this.isEnableOperate("edit");
    }

    public final boolean isEnableDel() {
        return this.isEnableOperate("del");
    }

    public final boolean isEnableRun() {
        return this.isEnableOperate("run");
    }

    protected boolean isEnableOperate(String operate) {
        String funcno = this.parseFuncno();
        if (funcno == null) {
            return true;
        }
        String attrname = "AUTH_" + funcno + "_" + operate;
        Boolean result = (Boolean)this.getRequestAttribute(attrname);
        if (result != null) {
            return result;
        }
        result = true;
        try {
            this.authenticate(funcno, operate);
        }
        catch (Exception ex) {
            result = false;
        }
        this.setRequestAttribute(attrname, result);
        return result;
    }

    protected final void authenticate(String operate) {
        this.authenticate(this.parseFuncno(), operate);
    }

    protected void authenticate(String funcno, String operate) {
        if (funcno == null || operate == null) {
            return;
        }
        UserInfo userinfo = this.currentUserInfo();
        if (userinfo == null) {
            throw new XLRuntimeException("\u7528\u6237\u6ca1\u6709\u767b\u5f55.");
        }
        this.addFuncLogs(funcno, this.currentUserLogo());
        if (userinfo.isSuperman()) {
            return;
        }
        if (commfacade.authByRole(funcno, operate, userinfo.getRolenos())) {
            return;
        }
        throw new XLRuntimeException("\u6ca1\u6709\u8be5\u6a21\u5757\u7684\u6743\u9650.");
    }

    protected void addFuncLogs(String funcno, String userlogno) {
        if (this.isEmpty(userlogno)) {
            return;
        }
        List<Functions> list = commfacade.getFunctionsByFuncNo(funcno);
        String systemModel = "";
        if (list != null && list.size() > 0) {
            systemModel = list.get(0).getModuleno();
        }
        HttpSession session = (HttpSession)FacesContext.getCurrentInstance().getExternalContext().getSession(true);
        String lastFunc = (String)session.getAttribute("FUNC_LOG_" + userlogno);
        logger.debug("\u7528\u6237\uff1a" + userlogno + " \u6700\u540e\u8bbf\u95ee\u6a21\u5757\u540d\u79f0\u4e3a\uff1a" + lastFunc);
        if (lastFunc == null || !lastFunc.equals(funcno)) {
            Functionlogs logs = new Functionlogs();
            logs.setFuncno(funcno);
            logs.setModuleno(systemModel);
            logs.setUserlogno(userlogno);
            logs.setEdittime(this.now());
            logs.setEditip(this.getClientAddr());
            commfacade.insertFunctionlogs(logs);
            session.setAttribute("FUNC_LOG_" + userlogno, funcno);
        }
    }

    protected String parseFuncno() {
        FunRef fun = this.getClass().getAnnotation(FunRef.class);
        return fun == null ? null : fun.value();
    }

    protected List<SelectItem> transfer(Map<?, ?> map) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(map.size());
        for (Map.Entry<?, ?> s : map.entrySet()) {
            items.add(new SelectItem(s.getKey(), "" + s.getValue()));
        }
        return items;
    }

    protected List<SelectItem> transfer(List<String> list) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(list.size());
        for (String s : list) {
            items.add(new SelectItem((Object)s, s));
        }
        return items;
    }

    protected List<SelectItem> getCachedFromLibclassm(String libclassmid) {
        List<SelectItem> cached = (List<SelectItem>)this.getRequestAttribute(libclassmid + "List");
        if (cached == null) {
            Map<String, String> map = LibClassM.getStringValues(libclassmid);
            cached = this.transfer(map);
            this.setRequestAttribute(libclassmid + "List", cached);
        }
        return cached;
    }

    protected Map<String, String> getCachedMapFromLibclassm(String libclassmid) {
        Map<String, String> cached = (Map<String, String>)this.getRequestAttribute(libclassmid + "Map");
        if (cached == null) {
            cached = LibClassM.getStringValues(libclassmid);
            this.setRequestAttribute(libclassmid + "Map", cached);
        }
        return cached;
    }

    private int getPageSize(int index, PagedFliper fliper) {
        boolean changed = false;
        UserCookie uc = new UserCookie(this.getHttpServletRequest(), this.getHttpServletResponse(), this.getContextPath().equals("") ? "/" : this.getContextPath(), null);
        int size = 0;
        String cookieName = "xlp_pagesize_";
        int pagesizeCookie = StringTools.safeToInt(uc.getCookie(cookieName, false));
        int pagesizeStrHd = StringTools.safeToInt(this.findParameter(AbstractManagedBean.getHiddenPageSizeId(index)));
        size = pagesizeCookie;
        if (pagesizeCookie == 0) {
            size = pagesizeStrHd;
        }
        if (size == 0) {
            size = fliper.getPageSize();
        }
        if (pagesizeStrHd != 0 && pagesizeCookie != pagesizeStrHd) {
            size = pagesizeStrHd;
            changed = true;
        }
        if (changed) {
            uc.addC(cookieName, size + "", 31536000);
        }
        return size;
    }

    public String getCookie(String key) {
        String rs = null;
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(key)) continue;
                rs = c.getValue();
            }
        }
        return rs;
    }

    public void addCookie(String name, String value, int maxage) {
        Cookie cookie = new Cookie(name, value);
        String cookiePath = "/";
        if (StringTools.isNotEmpty(this.getContextPath())) {
            cookiePath = this.getContextPath();
        }
        cookie.setPath(cookiePath);
        if (maxage > 0) {
            cookie.setMaxAge(maxage);
        } else {
            cookie.setMaxAge(-1);
        }
        this.getHttpServletResponse().addCookie(cookie);
    }

    public boolean isPostback() {
        return FacesContext.getCurrentInstance().getRenderKit().getResponseStateManager().isPostback(FacesContext.getCurrentInstance());
    }

    public ServletContext getContext() {
        return (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
    }

    static {
        try {
            PagedFliper.DEFAULTPAGESIZE = Integer.parseInt(LibConfig.getValue("PageSize"));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

