/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import com.xunlei.common.util.StringTools;

class ScriptBlock {
    private String scriptName;
    private String cu;
    private String runVersion;
    private String nextScriptName;
    private String scriptContent;
    private ScriptBlock nextBlock;
    private String[] sqls;
    private int currentSqlIndex;

    public String toString() {
        return "[name:" + this.scriptName + ",cu:" + this.cu + ",runVersion:" + this.runVersion + ",nextScriptName:" + this.nextScriptName + "]\r\nscriptContent:" + this.scriptContent;
    }

    public ScriptBlock(String name, String cu, String runVersion, String nextScriptName, String scriptContent) {
        this.scriptName = name;
        this.cu = cu;
        this.runVersion = runVersion;
        this.nextScriptName = nextScriptName;
        this.scriptContent = scriptContent;
        this.nextBlock = null;
        this.sqls = null;
        this.currentSqlIndex = 0;
    }

    public ScriptBlock() {
        this.nextBlock = null;
        this.sqls = null;
        this.currentSqlIndex = 0;
    }

    public String getNextSql() {
        if (this.sqls == null) {
            this.sqls = this.scriptContent.split("\\;\\s*");
        }
        if (this.currentSqlIndex < this.sqls.length) {
            return this.sqls[this.currentSqlIndex++];
        }
        return null;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getCu() {
        return this.cu;
    }

    public void setCu(String cu) {
        this.cu = cu;
    }

    public boolean wantRun(String setcu, double currentVersion, double updateToVersion) {
        if (StringTools.isEmpty(this.cu)) {
            this.cu = "CU";
        }
        return setcu.equals("C") ? this.cu.indexOf("C") >= 0 && (this.getRunVersion() == 0.0 || this.getRunVersion() <= updateToVersion) : this.cu.indexOf("U") >= 0 && (this.getRunVersion() == 0.0 || this.getRunVersion() > currentVersion && this.getRunVersion() <= updateToVersion);
    }

    public double getRunVersion() {
        if (StringTools.isEmpty(this.runVersion)) {
            return 0.0;
        }
        return Double.parseDouble(this.runVersion);
    }

    public void setRunVersion(String runVersion) {
        this.runVersion = runVersion;
    }

    public String getNextScriptName() {
        return this.nextScriptName;
    }

    public void setNextScriptName(String nextScriptName) {
        this.nextScriptName = nextScriptName;
    }

    public String getScriptContent() {
        return this.scriptContent;
    }

    public void setScriptContent(String scriptContent) {
        this.scriptContent = scriptContent;
        this.sqls = null;
        this.currentSqlIndex = 0;
    }

    public ScriptBlock getNextBlock() {
        return this.nextBlock;
    }

    public void setNextBlock(ScriptBlock nextBlock) {
        this.nextBlock = nextBlock;
    }
}

