/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import com.xunlei.common.util.ExplorerParams;
import com.xunlei.common.util.XLRuntimeException;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfExplorer<T> {
    private ExplorerParams<T> ep;
    private Class clazz;
    private float[] widths;
    private int[] horiz;
    private static BaseFont bfChinese = null;
    private Color[] colors;

    public PdfExplorer(ExplorerParams<T> param) {
        this.ep = param;
        this.paramCheck();
    }

    private void paramCheck() {
        if (this.ep.getClazz() == null || this.ep.getTitle() == null || this.ep.getHeaderNames() == null || this.ep.getDataFieldNames() == null || this.ep.getDatalist() == null) {
            throw new XLRuntimeException("\u5fc5\u987b\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.clazz = this.ep.getClazz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wirtedata(OutputStream out) {
        Document doc = new Document(PageSize.A4, 10.0f, 10.0f, 10.0f, 10.0f);
        try {
            PdfWriter.getInstance((Document)doc, (OutputStream)out);
            doc.open();
            int fontsize = this.ep.getFontSize();
            ArrayList<T> datalist = this.ep.getDatalist();
            String[] headNames = this.ep.getHeaderNames().split(",");
            String[] dataFields = this.ep.getDataFieldNames().split(",");
            String[] rowStyles = null;
            if (this.ep.getDataFieldStyles() != null && !this.ep.getDataFieldStyles().equals("")) {
                rowStyles = this.ep.getDataFieldStyles().split(",");
            }
            if (headNames.length == 0 || headNames.length != dataFields.length) {
                throw new XLRuntimeException("\u53c2\u6570\u8bbe\u7f6e\u6709\u8bef");
            }
            if (rowStyles != null && rowStyles.length != headNames.length) {
                throw new XLRuntimeException("\u6837\u5f0f\u8bbe\u7f6e\u6709\u8bef,\u6837\u5f0f\u4e2a\u6570\u5fc5\u987b\u4e0e\u603b\u5217\u6570\u76f8\u7b49");
            }
            int pagesize = this.ep.getPageSize();
            int row = datalist.size();
            int col = headNames.length;
            int pageCount = (datalist.size() + pagesize - 1) / pagesize;
            Font fonttitle = new Font(bfChinese, (float)(fontsize + 2), 1);
            Font fonthead = new Font(bfChinese, (float)fontsize, 1);
            Font fontfoot = new Font(bfChinese, 6.0f, 0);
            this.setTableStyle(col, rowStyles);
            for (int i = 0; i < pageCount; ++i) {
                if (i == 0) {
                    Paragraph title = new Paragraph(this.ep.getTitle(), fonttitle);
                    title.setAlignment(1);
                    Chapter chapter = new Chapter(title, 1);
                    chapter.setNumberDepth(0);
                    doc.add((Element)chapter);
                }
                Table table = new Table(col, row);
                table.setWidths(this.widths);
                table.setBorderWidth(0.0f);
                table.setPadding((float)this.ep.getTableCellPadding());
                table.setSpacing((float)this.ep.getTableCellSpace());
                for (int j = 0; j < col; ++j) {
                    Paragraph hp = new Paragraph(headNames[j], fonthead);
                    hp.setAlignment(1);
                    Cell hc = new Cell((Element)hp);
                    hc.setHorizontalAlignment(1);
                    hc.setHeader(true);
                    table.addCell(hc);
                }
                table.endHeaders();
                int maxrow = 0;
                maxrow = pageCount == 1 ? row : (pageCount - 1 == i ? row : (i + 1) * pagesize);
                for (int m = i * pagesize; m < maxrow; ++m) {
                    T t = datalist.get(m);
                    for (int k = 0; k < col; ++k) {
                        Font fontdata = new Font(bfChinese, (float)fontsize, 0, this.colors[k]);
                        String methodname = "get" + PdfExplorer.capitalize(dataFields[k]);
                        Method method = this.clazz.getDeclaredMethod(methodname, new Class[0]);
                        Object value = method.invoke(t, new Object[0]);
                        String valuestr = value.toString();
                        fontdata.setColor(this.colors[k]);
                        Paragraph datapara = new Paragraph(valuestr, fontdata);
                        Cell datacell = new Cell((Element)datapara);
                        datacell.setHorizontalAlignment(this.horiz[k]);
                        table.addCell(datacell);
                    }
                }
                String pageinfo = "\u5f53\u524d\u7b2c\u3010" + (i + 1) + "\u3011\u9875,\u5171" + pageCount + "\u9875";
                Paragraph footpara = new Paragraph(pageinfo, fontfoot);
                Cell footcell = new Cell((Element)footpara);
                footcell.setHorizontalAlignment(1);
                footcell.setVerticalAlignment(6);
                footcell.setColspan(col);
                table.addCell(footcell);
                doc.add((Element)table);
                doc.newPage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            doc.close();
        }
    }

    public void writeToFile(String filePath) {
        try {
            FileOutputStream fo = new FileOutputStream(filePath);
            this.wirtedata(fo);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private void setTableStyle(int col, String[] styles) {
        this.widths = new float[col];
        this.colors = new Color[col];
        this.horiz = new int[col];
        try {
            if (styles == null || styles.length == 0) {
                float width = (float)(1.0 / (double)col);
                for (int i = 0; i < col; ++i) {
                    this.widths[i] = width;
                    this.colors[i] = Color.BLACK;
                    this.horiz[i] = 1;
                }
            } else {
                float[] totalwidth = new float[col];
                float total = 0.0f;
                int index = 0;
                for (String str : styles) {
                    String colorstr;
                    StringTokenizer token = new StringTokenizer(str, "|");
                    if (token.hasMoreTokens()) {
                        float itemwidth;
                        String data = token.nextToken();
                        String widthdata = data.substring(0, data.length() - 1);
                        totalwidth[index] = itemwidth = Float.parseFloat(widthdata);
                        total += itemwidth;
                        String hdata = data.substring(data.length() - 1);
                        this.horiz[index] = hdata.equalsIgnoreCase("R") ? 2 : (hdata.equalsIgnoreCase("L") ? 0 : 1);
                    }
                    this.colors[index] = token.hasMoreTokens() ? ((colorstr = token.nextToken()).equalsIgnoreCase("red") ? Color.RED : (colorstr.equalsIgnoreCase("blue") ? Color.BLUE : (colorstr.equalsIgnoreCase("gray") ? Color.GRAY : (colorstr.equalsIgnoreCase("green") ? Color.GREEN : Color.BLACK)))) : Color.BLACK;
                    ++index;
                }
                for (int i = 0; i < col; ++i) {
                    this.widths[i] = totalwidth[i] / total;
                }
            }
        }
        catch (Exception e) {
            throw new XLRuntimeException("\u6837\u5f0f\u8bbe\u7f6e\u6709\u8bef");
        }
    }

    static {
        try {
            bfChinese = BaseFont.createFont((String)"/SIMYOU.TTF", (String)"Identity-H", (boolean)false);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

